/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.endecode.model;

import com.xforceplus.taxware.architecture.g1.endecode.exception.ZipFileException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.LocalFileHeader;
import org.apache.commons.io.IOUtils;

public class ZipFile {
    private static final int RETRY_COUNT = 3;
    private final Map<String, ByteArrayOutputStream> entryMap = new HashMap<String, ByteArrayOutputStream>();

    public ZipFile(InputStream inputStream) {
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            int nullCount = 0;
            while (nullCount < 3) {
                LocalFileHeader nextEntry = zipInputStream.getNextEntry();
                if (nextEntry != null) {
                    String fixPath = this.fixPath(nextEntry.getFileName());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)zipInputStream, (OutputStream)byteArrayOutputStream);
                    this.entryMap.put(fixPath, byteArrayOutputStream);
                    continue;
                }
                ++nullCount;
            }
        }
        catch (Exception ex) {
            throw new ZipFileException("\u521d\u59cb\u5316ZipFile\u65f6\u53d1\u751f\u5f02\u5e38", ex);
        }
    }

    public byte[] getBytes(String name) {
        String fixPath = this.fixPath(name);
        if (!this.entryMap.containsKey(fixPath)) {
            return null;
        }
        return this.entryMap.get(fixPath).toByteArray();
    }

    public InputStream getInputStream(String name) {
        String fixPath = this.fixPath(name);
        if (!this.entryMap.containsKey(fixPath)) {
            return null;
        }
        return new ByteArrayInputStream(this.entryMap.get(fixPath).toByteArray());
    }

    public boolean contains(String name) {
        String fixPath = this.fixPath(name);
        return this.entryMap.containsKey(fixPath);
    }

    public int getSize() {
        return this.entryMap.size();
    }

    private String fixPath(String rawPath) {
        if (rawPath.startsWith("/")) {
            return rawPath;
        }
        return String.format("/%s", rawPath);
    }
}

