/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.ofd;

import com.xforceplus.taxware.architecture.g1.ofd.config.OfdVerifyConfig;
import com.xforceplus.taxware.architecture.g1.ofd.exception.ErrorMsg;
import com.xforceplus.taxware.architecture.g1.ofd.exception.OfdVerifyTerminateException;
import com.xforceplus.taxware.architecture.g1.ofd.exception.VerifyTerminateException;
import com.xforceplus.taxware.architecture.g1.ofd.model.RevocationInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;

public class CertVerifyUtil {
    public static void doVerify(X509Certificate certificate, X509Certificate rootCa, OfdVerifyConfig config) throws Exception {
        RevocationInfo revocationInfo;
        certificate.checkValidity();
        if (rootCa != null) {
            certificate.verify(rootCa.getPublicKey());
        }
        CertVerifyUtil.verifyKeyUsage(certificate);
        if (config.isVerifyCertRevokeStatus() && (revocationInfo = CertVerifyUtil.getRevocationInfo(certificate)) != null) {
            throw new OfdVerifyTerminateException(ErrorMsg.CERT_REVOCATION.getCode(), ErrorMsg.CERT_REVOCATION.getMessage() + ",\u65f6\u95f4:" + revocationInfo.getRevocationDate().toString() + ",\u539f\u56e0:" + revocationInfo.getRevocationReson());
        }
    }

    public static RevocationInfo doVerifyAndReturnRevocationInfo(X509Certificate certificate, X509Certificate rootCa, OfdVerifyConfig config) throws Exception {
        try {
            certificate.checkValidity();
        }
        catch (CertificateExpiredException e) {
            System.out.println("[" + certificate.getSubjectDN().toString() + "]\u8bc1\u4e66\u8fc7\u671f");
        }
        if (rootCa != null) {
            try {
                certificate.verify(rootCa.getPublicKey());
            }
            catch (SignatureException se) {
                throw new OfdVerifyTerminateException(ErrorMsg.ROOT_CERT_NOT_MATCH);
            }
        }
        CertVerifyUtil.verifyKeyUsage(certificate);
        if (config.isVerifyCertRevokeStatus()) {
            return CertVerifyUtil.getRevocationInfo(certificate);
        }
        return null;
    }

    static boolean isRevoked(X509Certificate certificate) throws Exception {
        try {
            X509CRL crl = CertVerifyUtil.getCrlObj(certificate);
            if (crl == null) {
                return false;
            }
            boolean isRevoked = crl.isRevoked(certificate);
            if (isRevoked) {
                System.out.println("\u8bc1\u4e66\u88ab\u540a\u9500");
            }
            return isRevoked;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OfdVerifyTerminateException(ErrorMsg.ERROR_STATUS_REVOCATION.getCode(), ErrorMsg.ERROR_STATUS_REVOCATION.getMessage() + ":" + e.getMessage());
        }
    }

    static RevocationInfo getRevocationInfo(X509Certificate certificate) throws Exception {
        try {
            X509CRL crl = CertVerifyUtil.getCrlObj(certificate);
            if (crl == null) {
                System.out.println("\u672a\u80fd\u89e3\u6790\u5230CRL\u5bf9\u8c61\u4fe1\u606f");
                return null;
            }
            X509CRLEntry x509CRLEntry = crl.getRevokedCertificate(certificate.getSerialNumber());
            if (x509CRLEntry == null) {
                return null;
            }
            RevocationInfo revocationInfo = new RevocationInfo();
            revocationInfo.setRevocationDate(x509CRLEntry.getRevocationDate());
            revocationInfo.setRevocationReson(x509CRLEntry.getRevocationReason().name());
            return revocationInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OfdVerifyTerminateException(ErrorMsg.ERROR_STATUS_REVOCATION.getCode(), ErrorMsg.ERROR_STATUS_REVOCATION.getMessage() + ":" + e.getMessage());
        }
    }

    private static void verifyKeyUsage(X509Certificate certificate) throws VerifyTerminateException {
        boolean[] keyUsages = certificate.getKeyUsage();
        if (!keyUsages[0]) {
            throw new OfdVerifyTerminateException(ErrorMsg.INVALID_KEY_USAGE.getCode(), ErrorMsg.INVALID_KEY_USAGE.getMessage() + ":digital_signature");
        }
        if (!keyUsages[1]) {
            throw new OfdVerifyTerminateException(ErrorMsg.INVALID_KEY_USAGE.getCode(), ErrorMsg.INVALID_KEY_USAGE.getMessage() + ":non_repudiation");
        }
        if (!keyUsages[2]) {
            throw new OfdVerifyTerminateException(ErrorMsg.INVALID_KEY_USAGE.getCode(), ErrorMsg.INVALID_KEY_USAGE.getMessage() + ":key_encipherment");
        }
    }

    private static X509CRL getCrlObj(X509Certificate certificate) throws Exception {
        byte[] extensionValue = certificate.getExtensionValue("2.5.29.31");
        if (extensionValue == null) {
            System.out.println("\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728CRL\u5206\u53d1\u70b9\u4fe1\u606f");
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionValue);
        ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        DEROctetString derObject = (DEROctetString)asn1InputStream.readObject();
        DLSequence seq = (DLSequence)new ASN1InputStream(derObject.getOctets()).readObject();
        ArrayList<String> crlUrls = new ArrayList<String>();
        for (int i = 0; i < seq.size(); ++i) {
            ASN1Encodable tobj = seq.getObjectAt(i);
            while (!(tobj instanceof DEROctetString)) {
                if (tobj instanceof ASN1Sequence && ((ASN1Sequence)tobj).size() > 0) {
                    tobj = ((ASN1Sequence)tobj).getObjectAt(0);
                }
                if (!(tobj instanceof ASN1TaggedObject)) continue;
                tobj = ((ASN1TaggedObject)tobj).getObject();
            }
            String crlUrl = new String(((DEROctetString)tobj).getOctets());
            System.out.println(crlUrl);
            crlUrls.add(crlUrl);
        }
        X509CRL crl = null;
        for (String crlUrl : crlUrls) {
            if (crlUrl.startsWith("http")) {
                crl = CertVerifyUtil.getCrlByHttp(crlUrl);
            } else if (crlUrl.startsWith("ldap://")) {
                crl = CertVerifyUtil.getCrlByLdap(crlUrl);
            }
            if (crl == null) continue;
            break;
        }
        return crl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509CRL getCrlByHttp(String crlUrl) throws Exception {
        X509CRL crl = null;
        try (ByteArrayInputStream in = null;){
            byte[] result = CertVerifyUtil.httpGet(crlUrl);
            in = new ByteArrayInputStream(result);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            crl = (X509CRL)cf.generateCRL(in);
        }
        return crl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509CRL getCrlByLdap(String crlUrl) throws Exception {
        if (crlUrl == null && "".equals(crlUrl)) {
            return null;
        }
        X509CRL crl = null;
        try (ByteArrayInputStream in = null;){
            crlUrl = crlUrl.replace("ldap://", "LDAP://");
            LdapContext ctx = CertVerifyUtil.ldapConnect(crlUrl);
            byte[] fileContent = null;
            if (ctx == null) {
                X509CRL x509CRL = null;
                return x509CRL;
            }
            String filter = "objectClass=cRLDistributionPoint";
            String[] attrPersonArray = new String[]{"certificateRevocationList;binary"};
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(attrPersonArray);
            NamingEnumeration<SearchResult> answer = ctx.search("", filter.toString(), searchControls);
            while (answer.hasMore() && fileContent == null) {
                SearchResult result = answer.next();
                NamingEnumeration<? extends Attribute> attrs = result.getAttributes().getAll();
                if (!attrs.hasMore()) continue;
                Attribute attr = attrs.next();
                fileContent = (byte[])attr.get();
            }
            in = new ByteArrayInputStream(fileContent);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            crl = (X509CRL)cf.generateCRL(in);
        }
        return crl;
    }

    private static String getSerialNumber(X509Certificate cert) {
        if (null == cert) {
            return null;
        }
        byte[] serial = cert.getSerialNumber().toByteArray();
        if (serial.length > 0) {
            String serialNumberString = new String();
            for (int i = 0; i < serial.length; ++i) {
                String s = Integer.toHexString(Byte.valueOf(serial[i]).intValue());
                if (s.length() == 8) {
                    s = s.substring(6);
                } else if (1 == s.length()) {
                    s = "0" + s;
                }
                serialNumberString = serialNumberString + s + " ";
            }
            return serialNumberString;
        }
        return null;
    }

    private static LdapContext ldapConnect(String url) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        String factory = "com.sun.jndi.ldap.LdapCtxFactory";
        env.put("java.naming.factory.initial", factory);
        env.put("java.naming.security.authentication", "none");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.principal", "");
        env.put("java.naming.security.credentials", "");
        env.put("java.naming.batchsize", "1000");
        env.put("com.sun.jndi.ldap.connect.timeout", "5000");
        InitialLdapContext ldapContext = null;
        try {
            ldapContext = new InitialLdapContext(env, null);
            System.out.println("ldap connect success");
        }
        catch (AuthenticationException e) {
            System.out.println("ldap\u8ba4\u8bc1\u5931\u8d25");
        }
        catch (NamingException e) {
            System.out.println("ldap\u53c2\u6570\u6709\u8bef\u5bfc\u81f4\u8fde\u63a5\u5931\u8d25");
        }
        return ldapContext;
    }

    private static byte[] httpGet(String url) throws Exception {
        MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
        OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        HttpUrl finalUrl = urlBuilder.build();
        Request request = new Request.Builder().get().url(finalUrl).build();
        Response response = null;
        response = client.newCall(request).execute();
        byte[] result = response.body().bytes();
        if (response.isSuccessful()) {
            return result;
        }
        throw new Exception("http\u8bf7\u6c42\u5931\u8d25,Url: " + url + "\u72b6\u6001\u7801: " + response.code() + ", \u8bf7\u6c42\u7ed3\u679c: " + result);
    }
}

