/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.ofd;

import com.xforceplus.taxware.architecture.g1.endecode.model.ZipFile;
import com.xforceplus.taxware.architecture.g1.ofd.CertVerifyUtil;
import com.xforceplus.taxware.architecture.g1.ofd.config.OfdVerifyConfig;
import com.xforceplus.taxware.architecture.g1.ofd.exception.ErrorMsg;
import com.xforceplus.taxware.architecture.g1.ofd.exception.OfdVerifyTerminateException;
import com.xforceplus.taxware.architecture.g1.ofd.model.RevocationInfo;
import com.xforceplus.taxware.architecture.g1.ofd.model.basicStructure.ofd.OFD;
import com.xforceplus.taxware.architecture.g1.ofd.model.basicType.ST_Loc;
import com.xforceplus.taxware.architecture.g1.ofd.model.ses.v4.SES_ESPropertyInfo;
import com.xforceplus.taxware.architecture.g1.ofd.model.ses.v4.SES_Signature;
import com.xforceplus.taxware.architecture.g1.ofd.model.ses.v4.SESeal;
import com.xforceplus.taxware.architecture.g1.ofd.model.signatures.Signature;
import com.xforceplus.taxware.architecture.g1.ofd.model.signatures.Signatures;
import com.xforceplus.taxware.architecture.g1.ofd.model.signatures.range.Reference;
import com.xforceplus.taxware.architecture.g1.ofd.model.signatures.range.References;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jcajce.provider.digest.SM3;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class OFDVerifyUtil {
    public static void doInvoiceOfdVerify(InputStream ofdInputStream, String rootCaBase64Str, OfdVerifyConfig config) throws Exception {
        if ((null == rootCaBase64Str || "".equals(rootCaBase64Str)) && config.isVerifyRootCa()) {
            throw new OfdVerifyTerminateException(ErrorMsg.BLANK_PARAM);
        }
        byte[] data = Base64.getDecoder().decode(rootCaBase64Str);
        OFDVerifyUtil.doInvoiceOfdVerify(ofdInputStream, new ByteArrayInputStream(data), config);
    }

    public static void doInvoiceOfdVerify(InputStream ofdInputStream, InputStream rootCaDerFileInputStream, OfdVerifyConfig config) throws Exception {
        if (null == ofdInputStream || null == rootCaDerFileInputStream && config.isVerifyRootCa()) {
            throw new OfdVerifyTerminateException(ErrorMsg.BLANK_PARAM);
        }
        ZipFile ofdZipFile = new ZipFile(ofdInputStream);
        OFD ofd = OFDVerifyUtil.getXmlObj("OFD.xml", ofdZipFile, OFD::new);
        ST_Loc st_loc = ofd.getDocBody().getSignatures();
        if (st_loc == null) {
            throw new OfdVerifyTerminateException(ErrorMsg.SIGNATURE_MISSING);
        }
        try {
            java.security.cert.CertificateFactory cf = java.security.cert.CertificateFactory.getInstance("X.509", "BC");
            X509Certificate rootCa = null;
            if (config.isVerifyRootCa()) {
                rootCa = (X509Certificate)cf.generateCertificate(rootCaDerFileInputStream);
            }
            Signatures signatures = OFDVerifyUtil.getXmlObj(st_loc.getLoc(), ofdZipFile, Signatures::new);
            List<Signature> signatureList = signatures.getSignatures();
            for (Signature sig : signatureList) {
                ST_Loc baseLoc = sig.getBaseLoc();
                com.xforceplus.taxware.architecture.g1.ofd.model.signatures.sig.Signature sigObj = OFDVerifyUtil.getXmlObj(baseLoc.getLoc(), ofdZipFile, com.xforceplus.taxware.architecture.g1.ofd.model.signatures.sig.Signature::new);
                References refList = sigObj.getSignedInfo().getReferences();
                OFDVerifyUtil.verifyReferences(refList, ofdZipFile);
                String loc = sigObj.getSignedValue().getLoc();
                SES_Signature ses_signature = SES_Signature.getInstance(ofdZipFile.getBytes(OFDVerifyUtil.formatPath(loc)));
                OFDVerifyUtil.verifySESealSignature(ses_signature, ofdZipFile, rootCa, config);
            }
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new Exception("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
    }

    public static void verifySESealSignature(SES_Signature ses_signature, ZipFile ofdZipFile, X509Certificate rootCa, OfdVerifyConfig config) throws Exception {
        byte[] dataHash;
        String signatruePath;
        SM3.Digest md;
        byte[] digest;
        CertificateFactory factory = new CertificateFactory();
        X509Certificate certificate = (X509Certificate)factory.engineGenerateCertificate(ses_signature.getCert().getOctetStream());
        if (!OFDVerifyUtil.verifySignatureData(ses_signature.getSignatureAlgID().toString(), certificate, ses_signature.getToSign().getEncoded("DER"), ses_signature.getSignature().getBytes())) {
            throw new OfdVerifyTerminateException(ErrorMsg.INVALID_SIGNATURE);
        }
        SES_ESPropertyInfo ses_esPropertyInfo = ses_signature.getToSign().getEseal().geteSealInfo().getProperty();
        boolean isMatch = false;
        if (ses_esPropertyInfo.getCertListType().getValue().intValue() == 1) {
            Iterator<ASN1OctetString> iterator = ses_esPropertyInfo.getCertList().getCerts().iterator();
            while (iterator.hasNext()) {
                ASN1OctetString certOctet = iterator.next();
                if (!Arrays.equals(ses_signature.getCert().getOctets(), certOctet.getOctets())) continue;
                isMatch = true;
            }
        } else if (ses_esPropertyInfo.getCertListType().getValue().intValue() == 2) {
            SM3.Digest md2 = new SM3.Digest();
            byte[] certSm3Bytes = md2.digest(ses_signature.getCert().getOctets());
            Iterator<ASN1OctetString> iterator = ses_esPropertyInfo.getCertList().getCerts().iterator();
            while (iterator.hasNext()) {
                ASN1OctetString certOctet = iterator.next();
                if (!Arrays.equals(certSm3Bytes, certOctet.getOctets())) continue;
                isMatch = true;
            }
        }
        if (!isMatch) {
            throw new OfdVerifyTerminateException(ErrorMsg.CERT_NO_RELATION);
        }
        OFDVerifyUtil.verifySESeal(ses_signature, rootCa, config);
        RevocationInfo revocationInfo = CertVerifyUtil.doVerifyAndReturnRevocationInfo(certificate, rootCa, config);
        long signatureTime = ses_signature.getToSign().getTimeInfo().getDate().getTime();
        if (revocationInfo != null && signatureTime > revocationInfo.getRevocationDate().getTime()) {
            throw new OfdVerifyTerminateException(ErrorMsg.SIGN_CERT_DATE_AFTER_REVOCATE.getCode(), ErrorMsg.SIGN_CERT_DATE_AFTER_REVOCATE.getMessage() + ",\u5931\u6548\u539f\u56e0:" + revocationInfo.getRevocationReson());
        }
        long startTime = certificate.getNotBefore().getTime();
        if (signatureTime < startTime) {
            throw new OfdVerifyTerminateException(ErrorMsg.SIGNDATE_EARLY);
        }
        long endTime = certificate.getNotAfter().getTime();
        if (signatureTime > endTime) {
            throw new OfdVerifyTerminateException(ErrorMsg.SIGNDATE_LATE);
        }
        if (ofdZipFile != null && !Arrays.equals(digest = (md = new SM3.Digest()).digest(ofdZipFile.getBytes(OFDVerifyUtil.formatPath(signatruePath = ses_signature.getToSign().getPropertyInfo().getString()))), dataHash = ses_signature.getToSign().getDataHash().getBytes())) {
            throw new OfdVerifyTerminateException(ErrorMsg.ATTRIBUTE_DIFFERENCES);
        }
        if (ses_signature.getTimeStamp() == null) {
            return;
        }
    }

    private static void verifySESeal(SES_Signature ses_signature, X509Certificate rootCa, OfdVerifyConfig config) throws Exception {
        SESeal seSeal = ses_signature.getToSign().getEseal();
        if (!"ES".equals(seSeal.geteSealInfo().getHeader().getId().getString())) {
            throw new OfdVerifyTerminateException(ErrorMsg.INVALID_SEAL_FLAG);
        }
        if (4 != seSeal.geteSealInfo().getHeader().getVersion().getValue().intValue()) {
            System.out.println("\n********************** \u7535\u5b50\u5370\u7ae0\u6570\u636e\u7248\u672c\u53f7\u4e0d\u662f4,\u9a8c\u7b7e\u903b\u8f91\u53ef\u80fd\u4e0d\u517c\u5bb9 *************************\n");
        }
        ASN1OctetString cert = seSeal.getCert();
        CertificateFactory factory = new CertificateFactory();
        X509Certificate seSealCert = (X509Certificate)factory.engineGenerateCertificate(cert.getOctetStream());
        if (!OFDVerifyUtil.verifySignatureData(seSeal.getSignAlgID().toString(), seSealCert, seSeal.geteSealInfo().getEncoded("DER"), seSeal.getSignedValue().getBytes())) {
            throw new OfdVerifyTerminateException(ErrorMsg.INVALID_SEAL_SIGNATURE);
        }
        RevocationInfo revocationInfo = CertVerifyUtil.doVerifyAndReturnRevocationInfo(seSealCert, rootCa, config);
        long signatureTime = ses_signature.getToSign().getTimeInfo().getDate().getTime();
        if (revocationInfo != null && signatureTime > revocationInfo.getRevocationDate().getTime()) {
            throw new OfdVerifyTerminateException(ErrorMsg.SEAL_CERT_DATE_AFTER_REVOCATE.getCode(), ErrorMsg.SEAL_CERT_DATE_AFTER_REVOCATE.getMessage() + ",\u5931\u6548\u539f\u56e0:" + revocationInfo.getRevocationReson());
        }
        long certEndTime = seSealCert.getNotAfter().getTime();
        long certStartTime = seSealCert.getNotBefore().getTime();
        if (signatureTime < certStartTime || signatureTime > certEndTime) {
            throw new OfdVerifyTerminateException(ErrorMsg.INVALID_SIGNDATE_BETWEEN_SEALCERT);
        }
        long startTime = seSeal.geteSealInfo().getProperty().getValidStart().getDate().getTime();
        long endTime = seSeal.geteSealInfo().getProperty().getValidEnd().getDate().getTime();
        if (signatureTime < startTime || signatureTime > endTime) {
            throw new OfdVerifyTerminateException(ErrorMsg.INVALID_SIGNDATE_BETWEEN_SEAL);
        }
    }

    private static boolean verifySignatureData(String algId, Certificate certificate, byte[] data, byte[] signatureBytes) throws Exception {
        if (!GMObjectIdentifiers.sm2sign_with_sm3.toString().equals(algId)) {
            throw new OfdVerifyTerminateException(ErrorMsg.INVALID_SIGNATURE_FLAG);
        }
        signatureBytes = OFDVerifyUtil.correctTaxSignatureBytes(signatureBytes);
        java.security.Signature sg = java.security.Signature.getInstance("SM3WithSM2", (Provider)new BouncyCastleProvider());
        sg.initVerify(certificate);
        sg.update(data);
        byte[] octets = signatureBytes;
        return sg.verify(octets);
    }

    private static byte[] correctTaxSignatureBytes(byte[] signatureBytes) {
        if (signatureBytes == null) {
            return signatureBytes;
        }
        try {
            boolean isConstructed;
            if (signatureBytes.length < 2) {
                return signatureBytes;
            }
            byte berTagValue = signatureBytes[0];
            boolean bl = isConstructed = (berTagValue & 0x20) != 0;
            if (!isConstructed) {
                return signatureBytes;
            }
            if (signatureBytes[1] != signatureBytes.length - 2) {
                return signatureBytes;
            }
            boolean isCorrect = false;
            byte[] bigIntegerBytes1 = new byte[signatureBytes[3] + 2];
            System.arraycopy(signatureBytes, 2, bigIntegerBytes1, 0, signatureBytes[3] + 2);
            bigIntegerBytes1 = OFDVerifyUtil.correctBigIntgerBytes(bigIntegerBytes1);
            if (bigIntegerBytes1.length != signatureBytes[3] + 2) {
                isCorrect = true;
            }
            int nextBigIntegerIndex = 4 + signatureBytes[3];
            byte[] bigIntegerBytes2 = new byte[signatureBytes[nextBigIntegerIndex + 1] + 2];
            System.arraycopy(signatureBytes, nextBigIntegerIndex, bigIntegerBytes2, 0, signatureBytes[nextBigIntegerIndex + 1] + 2);
            bigIntegerBytes2 = OFDVerifyUtil.correctBigIntgerBytes(bigIntegerBytes2);
            if (bigIntegerBytes2.length != signatureBytes[nextBigIntegerIndex + 1] + 2) {
                isCorrect = true;
            }
            if (!isCorrect) {
                return signatureBytes;
            }
            byte[] result = new byte[bigIntegerBytes1.length + bigIntegerBytes2.length + 2];
            result[0] = berTagValue;
            result[1] = (byte)(result.length - 2);
            System.arraycopy(bigIntegerBytes1, 0, result, 2, bigIntegerBytes1.length);
            System.arraycopy(bigIntegerBytes2, 0, result, bigIntegerBytes1.length + 2, bigIntegerBytes2.length);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return signatureBytes;
        }
    }

    private static byte[] correctBigIntgerBytes(byte[] bigIntegerBytes) {
        if (bigIntegerBytes[0] != 2 || bigIntegerBytes[1] > bigIntegerBytes.length - 2) {
            return bigIntegerBytes;
        }
        if (bigIntegerBytes[2] != bigIntegerBytes[3] >> 7) {
            return bigIntegerBytes;
        }
        byte[] result = new byte[bigIntegerBytes.length - 1];
        System.arraycopy(bigIntegerBytes, 0, result, 0, 2);
        System.arraycopy(bigIntegerBytes, 3, result, 2, result[1] - 1);
        result[1] = (byte)(result[1] - 1);
        return result;
    }

    private static void verifyReferences(References refList, ZipFile ofdZipFile) throws Exception {
        Iterator<Reference> iterator = refList.getReferences().iterator();
        while (iterator.hasNext()) {
            SM3.Digest md = new SM3.Digest();
            Reference reference = iterator.next();
            String loc = reference.getFileRef().getLoc();
            byte[] fileBin = ofdZipFile.getBytes(OFDVerifyUtil.formatPath(loc));
            byte[] digest = md.digest(fileBin);
            if (Arrays.equals(digest, reference.getCheckValue())) continue;
            throw new OfdVerifyTerminateException(ErrorMsg.FILE_TAMPERED.getCode(), ErrorMsg.FILE_TAMPERED.getMessage() + ",\u8282\u70b9:" + loc);
        }
    }

    private static <R> R getXmlObj(String loc, ZipFile ofdZipFile, Function<Element, R> mapper) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(ofdZipFile.getInputStream(OFDVerifyUtil.formatPath(loc)));
        Element element = document.getRootElement();
        return mapper.apply(element);
    }

    private static String formatPath(String loc) {
        return loc.startsWith("/") ? loc.substring(1) : loc;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

