/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.ofd.model.attachment;

import com.xforceplus.taxware.architecture.g1.ofd.model.Const;
import com.xforceplus.taxware.architecture.g1.ofd.model.OFDElement;
import com.xforceplus.taxware.architecture.g1.ofd.model.basicType.STBase;
import com.xforceplus.taxware.architecture.g1.ofd.model.basicType.ST_Loc;
import java.time.LocalDate;
import org.dom4j.Element;

public class CT_Attachment
extends OFDElement {
    public CT_Attachment(Element proxy) {
        super(proxy);
    }

    public CT_Attachment() {
        super("Attachment");
    }

    public CT_Attachment setID(String id) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("\u9644\u4ef6\u6807\u8bc6\uff08ID\uff09\u4e3a\u7a7a");
        }
        this.addAttribute("ID", id);
        return this;
    }

    public String getID() {
        String str = this.attributeValue("ID");
        if (str == null || str.trim().length() == 0) {
            throw new IllegalArgumentException("\u9644\u4ef6\u6807\u8bc6\uff08ID\uff09\u4e3a\u7a7a");
        }
        return str;
    }

    public CT_Attachment setAttachmentName(String attachmentName) {
        if (attachmentName == null || attachmentName.trim().length() == 0) {
            throw new IllegalArgumentException("\u9644\u4ef6\u540d\u79f0\uff08Name\uff09\u4e3a\u7a7a");
        }
        this.addAttribute("Name", attachmentName);
        return this;
    }

    public String getAttachmentName() {
        String str = this.attributeValue("Name");
        if (str == null || str.trim().length() == 0) {
            throw new IllegalArgumentException("\u9644\u4ef6\u540d\u79f0\uff08Name\uff09\u4e3a\u7a7a");
        }
        return str;
    }

    public CT_Attachment setFormat(String format) {
        if (format == null || format.trim().length() == 0) {
            this.removeAttr("Format");
            return this;
        }
        this.addAttribute("Format", format);
        return this;
    }

    public String getFormat() {
        return this.attributeValue("Format");
    }

    public CT_Attachment setCreationDate(LocalDate creationDate) {
        if (creationDate == null) {
            this.removeAttr("CreationDate");
            return this;
        }
        this.addAttribute("CreationDate", creationDate.format(Const.DATE_FORMATTER));
        return this;
    }

    public LocalDate getCreationDate() {
        String str = this.attributeValue("CreationDate");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return LocalDate.parse(str, Const.DATE_FORMATTER);
    }

    public CT_Attachment setModDate(LocalDate modDate) {
        if (modDate == null) {
            this.removeAttr("ModDate");
            return this;
        }
        this.addAttribute("ModDate", modDate.format(Const.DATE_FORMATTER));
        return this;
    }

    public LocalDate getModDate() {
        String str = this.attributeValue("ModDate");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return LocalDate.parse(str, Const.DATE_FORMATTER);
    }

    public CT_Attachment setSize(Double size) {
        if (size == null) {
            this.removeAttr("Size");
            return this;
        }
        this.addAttribute("Size", STBase.fmt(size));
        return this;
    }

    public Double getSize() {
        String str = this.attributeValue("Size");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return Double.parseDouble(str);
    }

    public CT_Attachment setVisible(Boolean visible) {
        if (visible == null) {
            this.removeAttr("Visible");
            return this;
        }
        this.addAttribute("Visible", Boolean.toString(visible));
        return this;
    }

    public Boolean getVisible() {
        String str = this.attributeValue("Visible");
        if (str == null || str.trim().length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(str);
    }

    public CT_Attachment setUsage(String usage) {
        if (usage == null || usage.trim().length() == 0) {
            this.removeAttr("Usage");
            return this;
        }
        this.addAttribute("Usage", usage);
        return this;
    }

    public String getUsage() {
        String str = this.attributeValue("Usage");
        if (str == null || str.trim().length() == 0) {
            return "none";
        }
        return str;
    }

    public CT_Attachment setFileLoc(ST_Loc fileLoc) {
        if (fileLoc == null) {
            this.removeOFDElemByNames("FileLoc");
            return this;
        }
        this.setOFDEntity("FileLoc", fileLoc);
        return this;
    }

    public ST_Loc getFileLoc() {
        Element e = this.getOFDElement("FileLoc");
        return e == null ? null : ST_Loc.getInstance(e);
    }
}

