/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.ofd.model.extensions;

import com.xforceplus.taxware.architecture.g1.ofd.model.Const;
import com.xforceplus.taxware.architecture.g1.ofd.model.OFDElement;
import com.xforceplus.taxware.architecture.g1.ofd.model.basicType.ST_Loc;
import com.xforceplus.taxware.architecture.g1.ofd.model.basicType.ST_RefID;
import com.xforceplus.taxware.architecture.g1.ofd.model.extensions.Property;
import java.time.LocalDate;
import java.util.List;
import org.dom4j.Element;

public class CT_Extension
extends OFDElement {
    public CT_Extension(Element proxy) {
        super(proxy);
    }

    public CT_Extension() {
        super("Extension");
    }

    public CT_Extension setAppName(String appName) {
        if (appName == null || appName.trim().length() == 0) {
            throw new IllegalArgumentException("\u7528\u4e8e\u751f\u6210\u6216\u89e3\u91ca\u8be5\u81ea\u5b9a\u4e49\u5bf9\u8c61\u6570\u636e\u7684\u6269\u5c55\u5e94\u7528\u7a0b\u5e8f\u540d\u79f0\uff08AppName\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.addAttribute("AppName", appName);
        return this;
    }

    public String getAppName() {
        String str = this.attributeValue("AppName");
        if (str == null || str.trim().length() == 0) {
            throw new IllegalArgumentException("\u7528\u4e8e\u751f\u6210\u6216\u89e3\u91ca\u8be5\u81ea\u5b9a\u4e49\u5bf9\u8c61\u6570\u636e\u7684\u6269\u5c55\u5e94\u7528\u7a0b\u5e8f\u540d\u79f0\uff08AppName\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return str;
    }

    public CT_Extension setCompany(String company) {
        if (company == null || company.trim().length() == 0) {
            this.removeAttr("Company");
            return this;
        }
        this.addAttribute("Company", company);
        return this;
    }

    public String getCompany() {
        return this.attributeValue("Company");
    }

    public CT_Extension setAppVersion(String appVersion) {
        if (appVersion == null || appVersion.trim().length() == 0) {
            this.removeAttr("AppVersion");
            return this;
        }
        this.addAttribute("AppVersion", appVersion);
        return this;
    }

    public String getAppVersion() {
        return this.attributeValue("AppVersion");
    }

    public CT_Extension setDate(LocalDate date) {
        if (date == null) {
            this.removeAttr("Date");
            return this;
        }
        this.addAttribute("Date", date.format(Const.DATE_FORMATTER));
        return this;
    }

    public LocalDate getDate() {
        String str = this.attributeValue("Date");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return LocalDate.parse(str, Const.DATE_FORMATTER);
    }

    public CT_Extension setRefId(ST_RefID refId) {
        if (refId == null) {
            this.removeAttr("RefId");
            return this;
        }
        this.addAttribute("RefId", refId.toString());
        return this;
    }

    public ST_RefID getRefId() {
        return ST_RefID.getInstance(this.attributeValue("RefId"));
    }

    public CT_Extension addProperty(Property property) {
        if (property == null) {
            return this;
        }
        this.add(property);
        return this;
    }

    public List<Property> getPropertys() {
        return this.getOFDElements("Property", Property::new);
    }

    public CT_Extension addExtendData(ST_Loc extendData) {
        if (extendData == null) {
            return this;
        }
        this.addOFDEntity("ExtendData", extendData);
        return this;
    }

    public List<ST_Loc> getExtendDatas() {
        return this.getOFDElements("ExtendData", ST_Loc::getInstance);
    }

    public CT_Extension addData(Element data) {
        if (data == null) {
            return this;
        }
        this.add(data);
        return this;
    }

    public List<Element> getDatas() {
        return this.elements("Data");
    }
}

