/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.ofd.model.pageDescription.drawParam;

import com.xforceplus.taxware.architecture.g1.ofd.model.OFDElement;
import com.xforceplus.taxware.architecture.g1.ofd.model.basicType.STBase;
import com.xforceplus.taxware.architecture.g1.ofd.model.basicType.ST_Array;
import com.xforceplus.taxware.architecture.g1.ofd.model.basicType.ST_ID;
import com.xforceplus.taxware.architecture.g1.ofd.model.basicType.ST_RefID;
import com.xforceplus.taxware.architecture.g1.ofd.model.graph.pathObj.FillColor;
import com.xforceplus.taxware.architecture.g1.ofd.model.graph.pathObj.StrokeColor;
import com.xforceplus.taxware.architecture.g1.ofd.model.pageDescription.color.color.CT_Color;
import com.xforceplus.taxware.architecture.g1.ofd.model.pageDescription.drawParam.LineCapType;
import com.xforceplus.taxware.architecture.g1.ofd.model.pageDescription.drawParam.LineJoinType;
import org.dom4j.Element;

public class CT_DrawParam
extends OFDElement {
    public CT_DrawParam(Element proxy) {
        super(proxy);
    }

    public CT_DrawParam(String name) {
        super("DrawParam");
    }

    public ST_ID getID() {
        return this.getObjID();
    }

    public CT_DrawParam setID(ST_ID id) {
        this.setObjID(id);
        return this;
    }

    public CT_DrawParam setRelative(ST_RefID relative) {
        this.addAttribute("Relative", relative.toString());
        return this;
    }

    public ST_RefID getRelative() {
        return ST_RefID.getInstance(this.attributeValue("Relative"));
    }

    public CT_DrawParam setLineWidth(Double lineWidth) {
        if (lineWidth == null) {
            this.removeAttr("LineWidth");
            return this;
        }
        if (lineWidth < 0.0) {
            throw new NumberFormatException("\u7ebf\u5bbd\u5fc5\u987b\u662f\u975e\u8d1f\u6d6e\u70b9\u6570");
        }
        this.addAttribute("LineWidth", STBase.fmt(lineWidth));
        return this;
    }

    public Double getLineWidth() {
        String str = this.attributeValue("LineWidth");
        if (str == null || str.trim().length() == 0) {
            return 0.353;
        }
        return Double.parseDouble(str);
    }

    public CT_DrawParam setJoin(LineJoinType join) {
        if (join == null) {
            this.removeAttr("Join");
            return this;
        }
        this.addAttribute("Join", join.toString());
        return this;
    }

    public LineJoinType getJoin() {
        return LineJoinType.getInstance(this.attributeValue("Join"));
    }

    public CT_DrawParam setCap(LineCapType cap) {
        if (cap == null) {
            this.removeAttr("Cap");
            return this;
        }
        this.addAttribute("Cap", cap.toString());
        return this;
    }

    public LineCapType getCap() {
        return LineCapType.getInstance(this.attributeValue("Cap"));
    }

    public CT_DrawParam setDashOffset(Double dashOffset) {
        if (dashOffset == null) {
            this.removeAttr("DashOffset");
            return this;
        }
        this.addAttribute("DashOffset", dashOffset.toString());
        return this;
    }

    public Double getDashOffset() {
        String str = this.attributeValue("DashOffset");
        if (str == null || str.trim().length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    public CT_DrawParam setDashPattern(ST_Array dashPattern) {
        if (dashPattern == null) {
            this.removeAttr("DashPattern");
            return this;
        }
        this.addAttribute("DashPattern", dashPattern.toString());
        return this;
    }

    public ST_Array getDashPattern() {
        return ST_Array.getInstance(this.attributeValue("DashPattern"));
    }

    public CT_DrawParam setMiterLimit(Double miterLimit) {
        if (miterLimit == null) {
            this.removeAttr("MiterLimit");
            return this;
        }
        this.addAttribute("MiterLimit", miterLimit.toString());
        return this;
    }

    public Double getMiterLimit() {
        String str = this.attributeValue("MiterLimit");
        if (str == null || str.trim().length() == 0) {
            return 3.528;
        }
        return Double.parseDouble(str);
    }

    public CT_DrawParam setFillColor(CT_Color fillColor) {
        if (fillColor == null) {
            this.removeOFDElemByNames("FillColor");
            return this;
        }
        fillColor.setOFDName("FillColor");
        this.set(fillColor);
        return this;
    }

    public FillColor getFillColor() {
        Element e = this.getOFDElement("FillColor");
        return e == null ? null : new FillColor(e);
    }

    public CT_DrawParam setStrokeColor(CT_Color strokeColor) {
        if (strokeColor == null) {
            this.removeOFDElemByNames("StrokeColor");
            return this;
        }
        strokeColor.setOFDName("StrokeColor");
        this.set(strokeColor);
        return this;
    }

    public CT_Color getStrokeColor() {
        Element e = this.getOFDElement("StrokeColor");
        return e == null ? null : new StrokeColor(e);
    }
}

