/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.ofd.model.ses.v1;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.BERSequence;

public class ExtData
extends ASN1Object {
    private ASN1ObjectIdentifier extnID;
    private ASN1Boolean critical = ASN1Boolean.FALSE;
    private ASN1OctetString extnValue;

    public ExtData() {
    }

    public ExtData(ASN1ObjectIdentifier extnID, ASN1Boolean critical, ASN1OctetString extnValue) {
        this.extnID = extnID;
        this.critical = critical;
        this.extnValue = extnValue;
    }

    public ExtData(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.extnID = ASN1ObjectIdentifier.getInstance(e.nextElement());
        this.critical = ASN1Boolean.getInstance(e.nextElement());
        this.extnValue = ASN1OctetString.getInstance(e.nextElement());
    }

    public static ExtData getInstance(Object o) {
        if (o instanceof ExtData) {
            return (ExtData)((Object)o);
        }
        if (o != null) {
            return new ExtData(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public ASN1ObjectIdentifier getExtnID() {
        return this.extnID;
    }

    public ExtData setExtnID(ASN1ObjectIdentifier extnID) {
        this.extnID = extnID;
        return this;
    }

    public ASN1Boolean getCritical() {
        return this.critical;
    }

    public ExtData setCritical(ASN1Boolean critical) {
        this.critical = critical;
        return this;
    }

    public ASN1OctetString getExtnValue() {
        return this.extnValue;
    }

    public ExtData setExtnValue(ASN1OctetString extnValue) {
        this.extnValue = extnValue;
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        v.add((ASN1Encodable)this.extnID);
        v.add((ASN1Encodable)this.critical);
        v.add((ASN1Encodable)this.extnValue);
        return new BERSequence(v);
    }
}

