/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.ofd.model.ses.v1;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERBitString;

public class SES_SignInfo
extends ASN1Object {
    private ASN1OctetString cert;
    private ASN1ObjectIdentifier signatureAlgorithm;
    private ASN1BitString signData;

    public SES_SignInfo() {
    }

    public static SES_SignInfo getInstance(Object o) {
        if (o instanceof SES_SignInfo) {
            return (SES_SignInfo)((Object)o);
        }
        if (o != null) {
            return new SES_SignInfo(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SES_SignInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.cert = ASN1OctetString.getInstance(e.nextElement());
        this.signatureAlgorithm = ASN1ObjectIdentifier.getInstance(e.nextElement());
        this.signData = DERBitString.getInstance(e.nextElement());
    }

    public SES_SignInfo(ASN1OctetString cert, ASN1ObjectIdentifier signatureAlgorithm, ASN1BitString signData) {
        this.cert = cert;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signData = signData;
    }

    public ASN1OctetString getCert() {
        return this.cert;
    }

    public SES_SignInfo setCert(ASN1OctetString cert) {
        this.cert = cert;
        return this;
    }

    public ASN1ObjectIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public SES_SignInfo setSignatureAlgorithm(ASN1ObjectIdentifier signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public ASN1BitString getSignData() {
        return this.signData;
    }

    public SES_SignInfo setSignData(ASN1BitString signData) {
        this.signData = signData;
        return this;
    }

    public SES_SignInfo setSignData(byte[] signData) {
        this.signData = new DERBitString(signData);
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        v.add((ASN1Encodable)this.cert);
        v.add((ASN1Encodable)this.signatureAlgorithm);
        v.add((ASN1Encodable)this.signData);
        return new BERSequence(v);
    }
}

