/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.ofd.model.ses.v1;

import com.xforceplus.taxware.architecture.g1.ofd.model.ses.v1.SES_SealInfo;
import com.xforceplus.taxware.architecture.g1.ofd.model.ses.v1.SES_SignInfo;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.BERSequence;

public class SESeal
extends ASN1Object {
    private SES_SealInfo esealInfo;
    private SES_SignInfo signInfo;

    public SESeal() {
    }

    public SESeal(SES_SealInfo esealInfo, SES_SignInfo signInfo) {
        this.esealInfo = esealInfo;
        this.signInfo = signInfo;
    }

    public SESeal(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.esealInfo = SES_SealInfo.getInstance(e.nextElement());
        this.signInfo = SES_SignInfo.getInstance(e.nextElement());
    }

    public static SESeal getInstance(Object o) {
        if (o instanceof SESeal) {
            return (SESeal)((Object)o);
        }
        if (o != null) {
            return new SESeal(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SES_SealInfo getEsealInfo() {
        return this.esealInfo;
    }

    public SESeal setEsealInfo(SES_SealInfo esealInfo) {
        this.esealInfo = esealInfo;
        return this;
    }

    public SES_SignInfo getSignInfo() {
        return this.signInfo;
    }

    public SESeal setSignInfo(SES_SignInfo signInfo) {
        this.signInfo = signInfo;
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        v.add((ASN1Encodable)this.esealInfo);
        v.add((ASN1Encodable)this.signInfo);
        return new BERSequence(v);
    }
}

