/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.ofd.model.ses.v4;

import com.xforceplus.taxware.architecture.g1.ofd.model.ses.v1.ExtensionDatas;
import com.xforceplus.taxware.architecture.g1.ofd.model.ses.v1.SES_ESPictrueInfo;
import com.xforceplus.taxware.architecture.g1.ofd.model.ses.v1.SES_Header;
import com.xforceplus.taxware.architecture.g1.ofd.model.ses.v4.SES_ESPropertyInfo;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERIA5String;

public class SES_SealInfo
extends ASN1Object {
    private SES_Header header;
    private DERIA5String esID;
    private SES_ESPropertyInfo property;
    private SES_ESPictrueInfo picture;
    private ExtensionDatas extDatas;

    public SES_SealInfo() {
    }

    public SES_SealInfo(SES_Header header, DERIA5String esID, SES_ESPropertyInfo property, SES_ESPictrueInfo picture, ExtensionDatas extDatas) {
        this.header = header;
        this.esID = esID;
        this.property = property;
        this.picture = picture;
        this.extDatas = extDatas;
    }

    public SES_SealInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.header = SES_Header.getInstance(e.nextElement());
        this.esID = DERIA5String.getInstance(e.nextElement());
        this.property = SES_ESPropertyInfo.getInstance(e.nextElement());
        this.picture = SES_ESPictrueInfo.getInstance(e.nextElement());
        if (e.hasMoreElements()) {
            this.extDatas = ExtensionDatas.getInstance(e.nextElement());
        }
    }

    public static SES_SealInfo getInstance(Object o) {
        if (o instanceof SES_SealInfo) {
            return (SES_SealInfo)((Object)o);
        }
        if (o != null) {
            return new SES_SealInfo(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SES_Header getHeader() {
        return this.header;
    }

    public SES_SealInfo setHeader(SES_Header header) {
        this.header = header;
        return this;
    }

    public DERIA5String getEsID() {
        return this.esID;
    }

    public SES_SealInfo setEsID(DERIA5String esID) {
        this.esID = esID;
        return this;
    }

    public SES_SealInfo setEsID(String esID) {
        this.esID = new DERIA5String(esID);
        return this;
    }

    public SES_ESPropertyInfo getProperty() {
        return this.property;
    }

    public SES_SealInfo setProperty(SES_ESPropertyInfo property) {
        this.property = property;
        return this;
    }

    public SES_ESPictrueInfo getPicture() {
        return this.picture;
    }

    public SES_SealInfo setPicture(SES_ESPictrueInfo picture) {
        this.picture = picture;
        return this;
    }

    public ExtensionDatas getExtDatas() {
        return this.extDatas;
    }

    public SES_SealInfo setExtDatas(ExtensionDatas extDatas) {
        this.extDatas = extDatas;
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(5);
        v.add((ASN1Encodable)this.header);
        v.add((ASN1Encodable)this.esID);
        v.add((ASN1Encodable)this.property);
        v.add((ASN1Encodable)this.picture);
        if (this.extDatas != null) {
            v.add((ASN1Encodable)this.extDatas);
        }
        return new BERSequence(v);
    }
}

