/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.ofd.model.ses.v4;

import com.xforceplus.taxware.architecture.g1.ofd.model.ses.v4.SES_SealInfo;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;

public class SESeal
extends ASN1Object {
    private SES_SealInfo eSealInfo;
    private ASN1OctetString cert;
    private ASN1ObjectIdentifier signAlgID;
    private ASN1BitString signedValue;

    public SESeal() {
    }

    public SESeal(SES_SealInfo eSealInfo, ASN1OctetString cert, ASN1ObjectIdentifier signAlgID, ASN1BitString signedValue) {
        this.eSealInfo = eSealInfo;
        this.cert = cert;
        this.signAlgID = signAlgID;
        this.signedValue = signedValue;
    }

    public SESeal(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.eSealInfo = SES_SealInfo.getInstance(e.nextElement());
        this.cert = ASN1OctetString.getInstance(e.nextElement());
        this.signAlgID = ASN1ObjectIdentifier.getInstance(e.nextElement());
        this.signedValue = DERBitString.getInstance(e.nextElement());
    }

    public static SESeal getInstance(Object o) {
        if (o instanceof SESeal) {
            return (SESeal)((Object)o);
        }
        if (o != null) {
            return new SESeal(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SES_SealInfo geteSealInfo() {
        return this.eSealInfo;
    }

    public SESeal seteSealInfo(SES_SealInfo eSealInfo) {
        this.eSealInfo = eSealInfo;
        return this;
    }

    public ASN1OctetString getCert() {
        return this.cert;
    }

    public SESeal setCert(ASN1OctetString cert) {
        this.cert = cert;
        return this;
    }

    public SESeal setCert(Certificate cert) throws CertificateEncodingException {
        this.cert = new DEROctetString(cert.getEncoded());
        return this;
    }

    public ASN1ObjectIdentifier getSignAlgID() {
        return this.signAlgID;
    }

    public SESeal setSignAlgID(ASN1ObjectIdentifier signAlgID) {
        this.signAlgID = signAlgID;
        return this;
    }

    public ASN1BitString getSignedValue() {
        return this.signedValue;
    }

    public SESeal setSignedValue(ASN1BitString signedValue) {
        this.signedValue = signedValue;
        return this;
    }

    public SESeal setSignedValue(byte[] signedValue) {
        this.signedValue = new DERBitString(signedValue);
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(4);
        v.add((ASN1Encodable)this.eSealInfo);
        v.add((ASN1Encodable)this.cert);
        v.add((ASN1Encodable)this.signAlgID);
        v.add((ASN1Encodable)this.signedValue);
        return new BERSequence(v);
    }
}

