package com.xforceplus.taxware.architecture.g1.rocketmq.client.model;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Data
public class RmqMessage {

    /**
     * 主题
     */
    private String topic;

    /**
     * 标签
     */
    private String tags;

    /**
     * 关键字
     */
    private String keys;

    /**
     * 延时等级
     */
    private int delayTimeLevel;

    /**
     * 消息属性
     */
    @Setter(AccessLevel.PRIVATE)
    private Map<String, String> properties = new HashMap<>();

    /**
     * 消息体
     */
    private String body;

    public void putProperty(final String key, final String value) {
        this.properties.put(key, value);
    }

    public String getProperty(final String key) {
        return this.properties.get(key);
    }

    public boolean containsProperty(final String key) {
        return this.properties.containsKey(key);
    }

    public void putAllProperties(final Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    public void setKeys(final String keys) {
        this.keys = keys;
    }

    public void setKeys(final Collection<String> keys) {
        if (keys == null) {
            return;
        }

        this.keys = StringUtils.join(keys, " ").trim();
    }
}
