package com.xforceplus.taxware.architecture.g1.rocketmq.client.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.xforceplus.taxware.architecture.g1.domain.util.ApplicationUtil;
import com.xforceplus.taxware.architecture.g1.domain.util.IDUtil;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.RmqSender;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.exception.RmqConsumeException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;

@Slf4j
public class DefaultRmqByOssSender implements RmqSender {

    private static final String END_POINT = "oss-cn-hangzhou.aliyuncs.com";
    private static final String BUCKET = "taxware-sl";
    private static final String AK = "LTAI4FeeXQDaWemFioYP6ZGL";
    private static final String SK = "72oAyMQdpFclRDAF7NkIP45RRimpPZ";

    private final OSSClient ossClient;

    public DefaultRmqByOssSender() {
        CredentialsProvider credentialsProvider = new DefaultCredentialProvider(AK, SK);
        ossClient = new OSSClient(END_POINT, credentialsProvider, new ClientConfiguration());
    }

    public String send(String data) {

        final String key = String.format("rmq-message/%s/%s/%s.%s", ApplicationUtil.getEnv(), DateFormatUtils.format(new Date(), "yyyy-MM-dd"), IDUtil.genUUID32(), "json");
        // final String url = String.format("https://taxware-sl.oss-cn-hangzhou.aliyuncs.com/%s", key);
        this.putObjectRequest(key, data);
        return generatePresignedUrl(key);
    }

    public String getData(String url) {

        try {

            final URL bUrl = new URL(url);
            final String key = bUrl.getPath().replaceFirst("^/", "");
            final OSSObject ossObject = ossClient.getObject(BUCKET, key);

            try (InputStream inputStream = ossObject.getObjectContent()) {
                return IOUtils.readStreamAsString(inputStream, StandardCharsets.UTF_8.name());
            }

        } catch (Exception e) {
            log.error("消费RMQ大报文异常", e);
            throw new RmqConsumeException(String.format("消费异常，读取数据时，%s", Optional.ofNullable(e.getMessage()).orElse(e.getClass().getName())), e);
        }
    }

    private void putObjectRequest(String key, String content) {
        final ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType("application/json");
        final PutObjectRequest putObjectRequest = new PutObjectRequest(BUCKET, key, new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), objectMetadata);
        ossClient.putObject(putObjectRequest);
    }

    private String generatePresignedUrl(String key) {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, 30);
        URL url = this.ossClient.generatePresignedUrl(BUCKET, key, cal.getTime(), HttpMethod.GET);
        return url.toString();
    }
}
