package com.xforceplus.taxware.architecture.g1.rocketmq.client.util;

import com.xforceplus.taxware.architecture.g1.rocketmq.client.Constants;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.exception.RmqException;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayOutputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;

import static com.xforceplus.taxware.architecture.g1.rocketmq.client.Constants.DelayLevelNames;

public class RmqUtils {
    public static String compressToString(byte[] data) {
        final ByteArrayOutputStream gzipData = new ByteArrayOutputStream();

        try (final GZIPOutputStream gzipOut = new GZIPOutputStream(gzipData)) {
            gzipOut.write(data);
            gzipOut.flush();
            return Base64.encodeBase64String(gzipData.toByteArray());
        } catch (Exception ex) {
            throw new RmqException(String.format("压缩二进制数据到Base64时异常，%s", Optional.ofNullable(ex.getMessage()).orElse(ex.getClass().getSimpleName())));
        }
    }

    @Nullable
    public static String getDelayLevelName(final int delayLevel) {
        if (delayLevel < 0 || delayLevel > DelayLevelNames.length - 1) {
            return null;
        }

        return DelayLevelNames[delayLevel];
    }

    public static int getDelayLevel(final String delayLevelName) {
        for (int i = 0; i < DelayLevelNames.length; i++) {
            final String name = DelayLevelNames[i];

            if (Objects.equals(name, delayLevelName)) {
                return i;
            }
        }

        return -1;
    }
}
