/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.rocketmq.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xforceplus.taxware.architecture.g1.core.mq.BaseMessageDTO;
import com.xforceplus.taxware.architecture.g1.domain.log.LogContext;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogEvent;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogSender;
import com.xforceplus.taxware.architecture.g1.domain.log.model.impl.MqLogEvent;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.RmqProducerSender;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.RmqSender;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.exception.RmqProduceException;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.model.RmqMessage;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.util.RmqUtils;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmqProducer
implements RmqProducerSender {
    private static final Logger log = LoggerFactory.getLogger(RmqProducer.class);
    private DefaultMQProducer defaultMQProducer;
    private LogSender logSender;
    private String indexName;
    private RmqSender rmqSender;

    public RmqProducer() {
    }

    public RmqProducer(String producerGroup, String accessKey, String secretKey) {
        AclClientRPCHook aclClientRPCHook = new AclClientRPCHook(new SessionCredentials(accessKey, secretKey));
        this.defaultMQProducer = new DefaultMQProducer(producerGroup, (RPCHook)aclClientRPCHook);
        this.defaultMQProducer.setMaxMessageSize(0x1800000);
    }

    public void setDefaultMQProducer(DefaultMQProducer defaultMQProducer) {
        this.defaultMQProducer = defaultMQProducer;
    }

    public void setNameSrvAddr(String nameSrvAddr) {
        this.defaultMQProducer.setNamesrvAddr(nameSrvAddr);
    }

    @Override
    public SendResult send(RmqMessage message) {
        MqLogEvent event = this.createEvent(message);
        try {
            Message msg = this.translate(message);
            event = this.createEvent(msg);
            try {
                SendResult sendResult = this.defaultMQProducer.send(msg);
                event.setSendStatus(sendResult.getSendStatus().name());
                SendResult sendResult2 = sendResult;
                return sendResult2;
            }
            catch (Exception e) {
                block10: {
                    SendResult sendResult;
                    block11: {
                        MQBrokerException mqBrokerException;
                        if (!(e instanceof MQBrokerException) || 2 != (mqBrokerException = (MQBrokerException)e).getResponseCode()) break block10;
                        event.getExt().put("retrySend", "true");
                        Thread.sleep(2000L);
                        SendResult sendResult3 = this.defaultMQProducer.send(msg);
                        event.setSendStatus(sendResult3.getSendStatus().name());
                        sendResult = sendResult3;
                        event.getExt().putAll(LogContext.getAllPoint());
                        if (this.logSender == null) break block11;
                        this.logSender.send((LogEvent)event);
                    }
                    return sendResult;
                }
                try {
                    throw e;
                }
                catch (Exception e2) {
                    log.error("RmqProducer\u53d1\u9001\u6d88\u606f\u65f6\u5f02\u5e38", (Throwable)e2);
                    event.setThrowable((Throwable)e2);
                    throw new RmqProduceException(Optional.ofNullable(e2.getMessage()).orElse(e2.getClass().getSimpleName()), e2);
                }
            }
        }
        finally {
            event.getExt().putAll(LogContext.getAllPoint());
            if (this.logSender != null) {
                this.logSender.send((LogEvent)event);
            }
        }
    }

    public SendResult send(List<RmqMessage> messages) {
        List events = messages.stream().map(this::createEvent).collect(Collectors.toList());
        try {
            List rmqMessages = messages.stream().map(this::translate).collect(Collectors.toList());
            SendResult sendResult = this.defaultMQProducer.send(rmqMessages);
            for (MqLogEvent event : events) {
                event.setSendStatus(sendResult.getSendStatus().name());
            }
            SendResult sendResult2 = sendResult;
            return sendResult2;
        }
        catch (Exception e) {
            log.error("RmqProducer\u53d1\u9001\u6d88\u606f\u65f6\u5f02\u5e38", (Throwable)e);
            for (MqLogEvent event : events) {
                event.setThrowable((Throwable)e);
            }
            throw new RmqProduceException(Optional.ofNullable(e.getMessage()).orElse(e.getClass().getSimpleName()), e);
        }
        finally {
            for (MqLogEvent event : events) {
                event.getExt().putAll(LogContext.getAllPoint());
                if (this.logSender == null) continue;
                this.logSender.send((LogEvent)event);
            }
        }
    }

    public void start() {
        try {
            this.defaultMQProducer.start();
        }
        catch (Exception e) {
            throw new RmqProduceException(String.format("\u751f\u4ea7\u8005\u542f\u52a8\u5f02\u5e38\uff0c%s", Optional.ofNullable(e.getMessage()).orElse(e.getClass().getName())));
        }
    }

    public void setLogSender(LogSender logSender) {
        this.logSender = logSender;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setRmqSender(RmqSender rmqSender) {
        this.rmqSender = rmqSender;
    }

    public void shutdown() {
        this.defaultMQProducer.shutdown();
    }

    private Message translate(RmqMessage message) {
        Message result = new Message();
        result.setTopic(message.getTopic());
        result.setTags(message.getTags());
        result.setDelayTimeLevel(message.getDelayTimeLevel());
        result.setKeys(message.getKeys());
        result.setBody(JSON.toJSONBytes((Object)this.createBaseMessageDTO(message), (SerializerFeature[])new SerializerFeature[0]));
        return result;
    }

    private BaseMessageDTO createBaseMessageDTO(RmqMessage message) {
        int sizeLimit = 0x100000;
        int messageContentSize = message.getBody().getBytes(StandardCharsets.UTF_8).length;
        BaseMessageDTO messageDTO = new BaseMessageDTO();
        BaseMessageDTO.Meta meta = new BaseMessageDTO.Meta();
        if (messageContentSize > 0x100000 && this.rmqSender != null) {
            meta.setVersion("2.0");
            String bodyUrl = this.rmqSender.send(message.getBody());
            messageDTO.setBody(bodyUrl);
        } else {
            messageDTO.setBody(message.getBody());
        }
        messageDTO.setMeta(meta);
        messageDTO.setProperties(message.getProperties());
        return messageDTO;
    }

    private MqLogEvent createEvent(RmqMessage message) {
        MqLogEvent event = new MqLogEvent();
        try {
            int messageContentSize = message.getBody().getBytes(StandardCharsets.UTF_8).length;
            event.setMessageContent(message.getBody());
            event.setMessageContentSize(messageContentSize);
            event.setMessageProperties(JSON.toJSONString(message.getProperties()));
            if (message.getDelayTimeLevel() > 0) {
                event.setDelayLevel(String.format("%s[%d]", RmqUtils.getDelayLevelName(message.getDelayTimeLevel()), message.getDelayTimeLevel()));
            }
            event.setTags(message.getTags());
            event.setKeys(message.getKeys());
            event.setService(this.indexName);
            event.setName(message.getTopic());
            event.setTraceId(LogContext.getTraceId());
            event.setType("RmqProducer");
            event.setThreadName(Thread.currentThread().getName());
            return event;
        }
        catch (Exception e) {
            log.warn("RmqProducer\u521b\u5efa\u57cb\u70b9\u4e8b\u4ef6\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            return event;
        }
    }

    private MqLogEvent createEvent(Message message) {
        MqLogEvent event = new MqLogEvent();
        try {
            event.setMessageContent(new String(message.getBody(), StandardCharsets.UTF_8));
            event.setMessageContentSize(message.getBody().length);
            event.setMessageProperties(JSON.toJSONString((Object)message.getProperties()));
            if (message.getDelayTimeLevel() > 0) {
                event.setDelayLevel(String.format("%s[%d]", RmqUtils.getDelayLevelName(message.getDelayTimeLevel()), message.getDelayTimeLevel()));
            }
            event.setTags(message.getTags());
            event.setKeys(message.getKeys());
            event.setService(this.indexName);
            event.setName(message.getTopic());
            event.setTraceId(LogContext.getTraceId());
            event.setType("RmqProducer");
            event.setThreadName(Thread.currentThread().getName());
            return event;
        }
        catch (Exception e) {
            log.warn("RmqProducer\u521b\u5efa\u57cb\u70b9\u4e8b\u4ef6\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            return event;
        }
    }
}

