/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.rocketmq.client.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.xforceplus.taxware.architecture.g1.domain.util.ApplicationUtil;
import com.xforceplus.taxware.architecture.g1.domain.util.IDUtil;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.RmqSender;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.exception.RmqConsumeException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRmqByOssSender
implements RmqSender {
    private static final Logger log = LoggerFactory.getLogger(DefaultRmqByOssSender.class);
    private static final String END_POINT = "oss-cn-hangzhou.aliyuncs.com";
    private static final String BUCKET = "taxware-sl";
    private static final String AK = "LTAI4FeeXQDaWemFioYP6ZGL";
    private static final String SK = "72oAyMQdpFclRDAF7NkIP45RRimpPZ";
    private final OSSClient ossClient;

    public DefaultRmqByOssSender() {
        DefaultCredentialProvider credentialsProvider = new DefaultCredentialProvider(AK, SK);
        this.ossClient = new OSSClient(END_POINT, (CredentialsProvider)credentialsProvider, new ClientConfiguration());
    }

    @Override
    public String send(String data) {
        String key = String.format("rmq-message/%s/%s/%s.%s", ApplicationUtil.getEnv(), DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"), IDUtil.genUUID32(), "json");
        this.putObjectRequest(key, data);
        return this.generatePresignedUrl(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getData(String url) {
        try {
            URL bUrl = new URL(url);
            String key = bUrl.getPath().replaceFirst("^/", "");
            OSSObject ossObject = this.ossClient.getObject(BUCKET, key);
            try (InputStream inputStream = ossObject.getObjectContent();){
                String string = IOUtils.readStreamAsString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
                return string;
            }
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39RMQ\u5927\u62a5\u6587\u5f02\u5e38", (Throwable)e);
            throw new RmqConsumeException(String.format("\u6d88\u8d39\u5f02\u5e38\uff0c\u8bfb\u53d6\u6570\u636e\u65f6\uff0c%s", Optional.ofNullable(e.getMessage()).orElse(e.getClass().getName())), e);
        }
    }

    private void putObjectRequest(String key, String content) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType("application/json");
        PutObjectRequest putObjectRequest = new PutObjectRequest(BUCKET, key, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), objectMetadata);
        this.ossClient.putObject(putObjectRequest);
    }

    private String generatePresignedUrl(String key) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 30);
        URL url = this.ossClient.generatePresignedUrl(BUCKET, key, cal.getTime(), HttpMethod.GET);
        return url.toString();
    }
}

