/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.rocketmq.client.util;

import com.xforceplus.taxware.architecture.g1.rocketmq.client.Constants;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.exception.RmqException;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.Nullable;

public class RmqUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String compressToString(byte[] data) {
        ByteArrayOutputStream gzipData = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOut = new GZIPOutputStream(gzipData);){
            gzipOut.write(data);
            gzipOut.flush();
            String string = Base64.encodeBase64String((byte[])gzipData.toByteArray());
            return string;
        }
        catch (Exception ex) {
            throw new RmqException(String.format("\u538b\u7f29\u4e8c\u8fdb\u5236\u6570\u636e\u5230Base64\u65f6\u5f02\u5e38\uff0c%s", Optional.ofNullable(ex.getMessage()).orElse(ex.getClass().getSimpleName())));
        }
    }

    @Nullable
    public static String getDelayLevelName(int delayLevel) {
        if (delayLevel < 0 || delayLevel > Constants.DelayLevelNames.length - 1) {
            return null;
        }
        return Constants.DelayLevelNames[delayLevel];
    }

    public static int getDelayLevel(String delayLevelName) {
        for (int i = 0; i < Constants.DelayLevelNames.length; ++i) {
            String name = Constants.DelayLevelNames[i];
            if (!Objects.equals(name, delayLevelName)) continue;
            return i;
        }
        return -1;
    }
}

