/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.snowflake;

import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.params.SetParams;

public class SnowFlake {
    private static final Logger logger = LoggerFactory.getLogger(SnowFlake.class);
    private static final String KEY_PATTERN = "SnowFlake-%s-%d";
    private static final int MAX_SEQUENCE = 1024;
    private static final long TTL = 7200L;
    private static final long interval = 1200000L;
    private final Option option;
    private final int workId;
    private final Generator generator;
    private final String cid = UUID.randomUUID().toString().toLowerCase();

    public SnowFlake(Option option) {
        logger.info("SnowFlake\u5f00\u59cb\u542f\u52a8, cid={}, option={}", (Object)this.cid, (Object)option.toString());
        this.option = option;
        this.workId = this.findWorkId();
        if (this.workId == 0) {
            String errorMessage = String.format("SnowFlake\u7684WorkId\u8d44\u6e90\u5df2\u8017\u5c3d! %s ", option.bizName);
            logger.error(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        this.generator = new Generator(this.workId);
        logger.info("SnowFlake\u7684WorkId\u4fdd\u6d3b\u5fc3\u8df3\u5f00\u542f! {} {}", (Object)option.bizName, (Object)this.cid);
        new Thread(this::heartbeat).start();
    }

    public long nextId() {
        return this.generator.nextId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void heartbeat() {
        while (true) {
            try {
                while (true) {
                    Jedis jedis;
                    block13: {
                        jedis = this.createJedis();
                        Throwable throwable = null;
                        try {
                            String key = String.format(KEY_PATTERN, this.option.bizName, this.workId);
                            jedis.expire(key, 7200L);
                            logger.info("SnowFlake\u7ef4\u6301\u5fc3\u8df3[{}][{}]\uff0c\u4e0b\u6b21\u5fc3\u8df3\u95f4\u9694[{}]", new Object[]{key, this.cid, 1200000L});
                            Thread.sleep(1200000L);
                            if (jedis == null) continue;
                            if (throwable == null) break block13;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (jedis == null) throw throwable4;
                                if (throwable == null) {
                                    jedis.close();
                                    throw throwable4;
                                }
                                try {
                                    jedis.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    jedis.close();
                }
            }
            catch (Exception ex) {
                logger.error("SnowFlake\u5fc3\u8df3\u5f02\u5e38\uff01" + Optional.ofNullable(ex.getMessage()).orElse(ex.getClass().getSimpleName()));
                continue;
            }
            break;
        }
    }

    private int findWorkId() {
        try (Jedis jedis = this.createJedis();){
            for (int i = 1; i <= 1024; ++i) {
                String key = String.format(KEY_PATTERN, this.option.bizName, i);
                SetParams params = new SetParams();
                params.nx();
                params.ex(7200L);
                String replyCode = jedis.set(key, this.cid, params);
                if (!"ok".equalsIgnoreCase(replyCode)) continue;
                int n = i;
                return n;
            }
            int n = 0;
            return n;
        }
    }

    private Jedis createJedis() {
        DefaultJedisClientConfig.Builder jedisConfigBuilder = DefaultJedisClientConfig.builder();
        jedisConfigBuilder.database(this.option.database);
        if (this.option.user != null && this.option.user.trim().length() > 0) {
            jedisConfigBuilder.user(this.option.user);
        }
        if (this.option.password != null && this.option.password.trim().length() > 0) {
            jedisConfigBuilder.password(this.option.password);
        }
        DefaultJedisClientConfig jedisClientConfig = jedisConfigBuilder.build();
        HostAndPort hp = new HostAndPort(this.option.host, this.option.port);
        return new Jedis(hp, (JedisClientConfig)jedisClientConfig);
    }

    private static class Generator {
        private static final long START_TIMESTAMP = 1627747200000L;
        private static final long SEQUENCE_BIT = 12L;
        private static final long MACHINE_BIT = 10L;
        private static final long DATA_CENTER_BIT = 0L;
        private static final long MAX_SEQUENCE = 4095L;
        private static final long MAX_MACHINE_NUM = 1023L;
        private static final long MAX_DATA_CENTER_NUM = 0L;
        private static final long MACHINE_LEFT = 12L;
        private static final long DATA_CENTER_LEFT = 22L;
        private static final long TIMESTAMP_LEFT = 22L;
        private final long dataCenterId = 0L;
        private final long machineId;
        private long sequence = 0L;
        private long lastTimeStamp = -1L;

        private long getNextMill() {
            long mill = this.getNewTimeStamp();
            while (mill <= this.lastTimeStamp) {
                mill = this.getNewTimeStamp();
            }
            return mill;
        }

        private long getNewTimeStamp() {
            return System.currentTimeMillis();
        }

        public Generator(long machineId) {
            if (machineId > 1023L || machineId < 0L) {
                throw new IllegalArgumentException("MachineId can't be greater than MAX_MACHINE_NUM or less than 0\uff01");
            }
            this.machineId = machineId;
        }

        public synchronized long nextId() {
            long currTimeStamp = this.getNewTimeStamp();
            if (currTimeStamp < this.lastTimeStamp) {
                throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
            }
            if (currTimeStamp == this.lastTimeStamp) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    currTimeStamp = this.getNextMill();
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimeStamp = currTimeStamp;
            return currTimeStamp - 1627747200000L << 22 | 0L | this.machineId << 12 | this.sequence;
        }
    }

    public static class Option {
        private String bizName = "Default";
        private String host;
        private int port;
        private int database = 1;
        private String user;
        private String password;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getDatabase() {
            return this.database;
        }

        public void setDatabase(int database) {
            this.database = database;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getBizName() {
            return this.bizName;
        }

        public void setBizName(String bizName) {
            this.bizName = bizName;
        }

        public String toString() {
            return "Option{bizName='" + this.bizName + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", database=" + this.database + ", user='" + this.user + '\'' + ", password='" + this.password + '\'' + '}';
        }
    }
}

