package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.BaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zhenmengying
 * @date 2023/2/9
 * @describe: 取得批量全电发票（xml）文件申请下载
 */
@Data
public class PostAllElectricInvoiceFileApplyDownloadMessage {

    @Data
    public static class Request {

        List<SubRequest> subRequests;

        @Data
        public static class SubRequest {
            /**
             * 发票代码（非必须）
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 开票日期
             * YYYY-MM-DD
             * HH:mm:ss
             */
            @JSONField(name = "kprq")
            private String dateTimeIssued;

            /**
             * 销售方识别号（非必须）
             */
            @JSONField(name = "xsfsbh")
            private String sellerTaxNo;

            /**
             * 购买方识别号（非必须）
             */
            @JSONField(name = "gmfsbh")
            private String buyerTaxNo;

            /**
             * 申请人识别号
             */
            @JSONField(name = "sqrsbh")
            private String applyTaxNo;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponse<Response.ResultData> {

        @Data
        @EqualsAndHashCode(callSuper = true)
        public static class ResultData extends BaseResponse.SubResponse.BaseResponseBody {

            /**
             * 批次流水号
             */
            @JSONField(name = "pclsh")
            private String taskId;

            /**
             * 明细信息
             */
            @JSONField(name = "clmxxx")
            private List<Detail> detail;

            @Data
            public static class Detail {

                /**
                 * 发票代码（非必须）
                 */
                @JSONField(name = "fpdm")
                private String invoiceCode;

                /**
                 * 发票号码（非必须）
                 */
                @JSONField(name = "fphm")
                private String invoiceNo;

                /**
                 * 开票日期（非必须）
                 */
                @JSONField(name = "kprq")
                private String dateIssued;

                /**
                 * 销售方识别号（非必须）
                 */
                @JSONField(name = "xsfsbh")
                private String sellerTaxNo;

                /**
                 * 购买方识别号（非必须）
                 */
                @JSONField(name = "gmfsbh")
                private String buyerTaxNo;

                /**
                 * 申请受理状态（非必须）
                 * 00：成功
                 * 01：失败
                 */
                @JSONField(name = "sqslzt")
                private String applyStatus;

                /**
                 * 处理失败说明（非必须）
                 * 申请受理状态为01：失败时记录
                 */
                @JSONField(name = "clsbsm")
                private String failReason;
            }
        }
    }
}
