package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.BaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zhenmengying
 * @date 2023/2/9
 * @describe: 取得批量全电发票文件申请结果反馈
 */
@Data
public class PostAllElectricInvoiceFileApplyResultMessage {

    @Data
    public static class Request {

        /**
         * 批次流水号
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 包号
         * 数据包号，当数据量过大时会进行分包处理,初始包号为1
         */
        @JSONField(name = "packageno")
        private String packageNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponse<Response.ResultData> {

        @Data
        @EqualsAndHashCode(callSuper = true)
        public static class ResultData extends BaseResponse.SubResponse.BaseResponseBody {

            /**
             * 总包数
             * 当前流水号下的总包数
             */
            @JSONField(name = "packagecount")
            private String total;

            /**
             * 发票反馈明细信息
             */
            @JSONField(name = "fpfkmxxx")
            private List<Detail> detail;

            @Data
            public static class Detail {

                /**
                 * 发票代码（非必须）
                 * 全电发票发票代码可为空
                 */
                @JSONField(name = "fpdm")
                private String invoiceCode;

                /**
                 * 发票号码
                 * 全电发票，发票号码20位
                 */
                @JSONField(name = "fphm")
                private String invoiceNo;

                /**
                 * 开票日期
                 * YYYY-MM-DD HH:mm:ss
                 */
                @JSONField(name = "kprq")
                private String dateTimeIssued;

                /**
                 * 销售方识别号（非必须）
                 */
                @JSONField(name = "xsfsbh")
                private String sellerTaxNo;

                /**
                 * 购买方识别号（非必须）
                 */
                @JSONField(name = "gmfsbh")
                private String buyerTaxNo;

                /**
                 * 处理结果
                 * 1-成功
                 * 2-不存在符合条件的发票
                 * 3-失败
                 */
                @JSONField(name = "cljg")
                private String returnCode;

                /**
                 * 数据流（非必须）
                 * 压缩包文件流（zip+base64）
                 */
                @JSONField(name = "sjl")
                private String returnData;
            }
        }
    }
}
