package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.BaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import java.math.BigDecimal;

/**
 * @author zhenmengying
 * @date 2023/1/16
 * @describe: 查询授信额度
 */
@Data
public class PostCreditLineMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码
         */
        @NotEmpty
        @Length(max = 26)
        @Pattern(regexp = "[A-Z0-9]+")
        @JSONField(name = "nsrsbh")
        private String taxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponse<Response.ResultData> {

        @Data
        @EqualsAndHashCode(callSuper = true)
        public static class ResultData extends BaseResponse.SubResponse.BaseResponseBody {

            /**
             * 暂停授信标志
             * Y：暂停 N：未暂停
             */
            @JSONField(name = "ztsxbz")
            private String pauseFlag;

            /**
             * 本月授信额度
             * 本月总授信额度
             */
            @JSONField(name = "bysxed")
            private BigDecimal amount;

            /**
             * 可用剩余额度
             * 本月可用授信额度
             */
            @JSONField(name = "kysyed")
            private BigDecimal remainAmount;

            /**
             * 已下载额度
             * 本月乐企1.5已下载的全部授信额度
             */
            @JSONField(name = "yxzed")
            private BigDecimal downloadedAmount;

            /**
             * 已下载未使用额度
             * 本月乐企1.5已下载的全部授信额度减已上传的开票日期为本月的发票的总金额
             */
            @JSONField(name = "yxzwsyed")
            private BigDecimal unUsedAmount;

            /**
             * 属期
             * 格式：yyyyMM
             */
            @JSONField(name = "sq")
            private String period;
        }
    }
}
