package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.BaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import java.util.Date;

/**
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 调整授信额度有效期
 */
@Data
public class PostCreditLinePeriodMessage {

    @Data
    public static class Request {

        /**
         * 统一社会信用代码/纳税人识别号/身份证件号码
         */
        @NotEmpty
        @Length(max = 26)
        @Pattern(regexp = "[A-Z0-9]+")
        @JSONField(name = "xsfnsrsbh")
        private String taxNo;

        /**
         * 授信额度属期
         * 格式：yyyy-MM
         */
        @JSONField(name = "sxedsq")
        private String period;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponse<Response.ResultData> {

        @Data
        @EqualsAndHashCode(callSuper = true)
        public static class ResultData extends BaseResponse.SubResponse.BaseResponseBody {

            /**
             * 授信额度属期
             * 格式：yyyy-MM
             */
            @JSONField(name = "sxedsq")
            private String period;

            /**
             * 授信额度使用区间起（非必须）
             * 下载授信额度时，有此节点
             * 全电发票开票日期在授信额度使用区间（含）时才可以使用.格式：yyyymmdd
             */
            @JSONField(name = "syqjq")
            private Date startCreditLineDate;

            /**
             * 授信额度使用区间止（非必须）
             * 下载授信额度时，有此节点
             * 全电发票开票日期在授信额度使用区间（含）时才可以使用.格式：yyyymmdd
             */
            @JSONField(name = "syqjz")
            private Date endCreditLineEndDate;
        }
    }
}
