package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.BaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author zhenmengying
 * @date 2023/1/17
 * @describe: 下载/退回授信额度
 */
@Data
public class PostDownloadSendBackCreditLineMessage {

    @Data
    public static class Request {

        /**
         * 申领发票的纳税人识别号或统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 平台编号
         */
        @JSONField(name = "ptbh")
        private String platformNo;

        /**
         * 申请类型
         */
        @JSONField(name = "nsrsbh")
        private String applyType;

        /**
         * 申请额度
         */
        @JSONField(name = "sqed")
        private Integer applyCreditLine;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponse<Response.ResultData> {

        @Data
        @EqualsAndHashCode(callSuper = true)
        public static class ResultData extends BaseResponse.SubResponse.BaseResponseBody {

            /**
             * 授信额度使用区间起（非必须）
             * 下载授信额度时，有此节点
             * 全电发票开票日期在授信额度使用区间（含）时才可以使用.格式：yyyymmdd
             */
            @JSONField(name = "syqjq")
            private Date startCreditLineDate;

            /**
             * 授信额度使用区间止（非必须）
             * 下载授信额度时，有此节点
             * 全电发票开票日期在授信额度使用区间（含）时才可以使用.格式：yyyymmdd
             */
            @JSONField(name = "syqjz")
            private Date endCreditLineDate;
        }
    }
}
