package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.BaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 全电红字确认单确认
 */
@Data
public class PostRedLetterConfirmMessage {

    @Data
    public static class Request {

        /**
         * 统一社会信用代码/纳税人识别号/身份证件号码
         */
        @JSONField(name = "xsfnsrsbh")
        private String taxNo;

        /**
         * 红字确认单UUID
         */
        @JSONField(name = "uuid")
        private String redLetterUuid;

        /**
         * 红字确认单编号
         */
        @JSONField(name = "hzqrdbh")
        private String redLetterNumber;

        /**
         * 确认类型
         * Y：同意
         * N：不同意
         */
        @JSONField(name = "qrlx")
        private String confirmStatus;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponse<Response.ResultData> {

        @Data
        @EqualsAndHashCode(callSuper = true)
        public static class ResultData extends BaseResponse.SubResponse.BaseResponseBody {

            /**
             * 确认日期（非必须）
             * yyyy-MM-dd HH:mm:ss
             */
            @JSONField(name = "qrrq")
            private Date confirmTime;
        }
    }
}
