package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.BaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 查询全电发票上传结果
 */
@Data
public class PostUploadAllElectricInvoiceResultMessage {

    @Data
    public static class Request {

        /**
         * 受理流水号
         */
        @JSONField(name = "sllsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponse<Response.ResultData> {

        @Data
        @EqualsAndHashCode(callSuper = true)
        public static class ResultData extends BaseResponse.SubResponse.BaseResponseBody {

            private List<InvoiceResult> resultList;

            @Data
            public static class InvoiceResult {

                /**
                 * 发票号码
                 */
                @JSONField(name = "fphm")
                private String invoiceNo;

                /**
                 * 上传状态
                 * 00：上传成功
                 * 01：发票上传处理中
                 * 02：上传失败
                 * 03：重复上传
                 */
                @JSONField(name = "status")
                private String uploadStatus;

                /**
                 * 详细信息（非必须）
                 */
                @JSONField(name = "message")
                private String detailMessage;

                /**
                 * 错误码（非必须）
                 * 未查询到上传结果会返回固定的Code值
                 */
                @JSONField(name = "Code")
                private String errorCode;
            }
        }
    }
}
