package com.xforceplus.taxware.leqi.kernel.contract.model.base;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.util.Objects;

/**
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 查询纳税人风险信息
 */

@Data
public class BaseResponse<T extends BaseResponse.SubResponse.BaseResponseBody> {

    @JSONField(name = "Response")
    private SubResponse<T> response;

    @Data
    public static class SubResponse<T extends SubResponse.BaseResponseBody> {

        /**
         * 16位随机数字和字母组合
         */
        @JSONField(name = "RequestId")
        private String requestId;

        @JSONField(name = "Data")
        private T responseBody;

        @Data
        public static class BaseResponseBody {

            /**
             * 返回码
             * 00：成功
             * 其它：失败
             */
            @JSONField(name = "returncode")
            private String returnCode;

            /**
             * 返回信息（非必须）
             * 错误信息说明
             */
            @JSONField(name = "returnmsg")
            private String returnMsg;
        }

        @JSONField(name = "Error")
        private ResponseError error;

        @Data
        public static class ResponseError {

            @JSONField(name = "Code")
            private String code;

            @JSONField(name = "Message")
            private String message;
        }
    }

    public boolean isSuccess() {
        return this.response != null
                && this.response.responseBody != null
                && Objects.equals(this.response.responseBody.getReturnCode(), "00")
                && this.response.error == null;
    }
}

