package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 全电发票xml文件下载
 *
 * @author zhouwen
 * @date 2023-03-08 17:45
 */
public class PostAeInvoiceXmlDownloadMessage {

    @Data
    public static class Request {

        private List<InvoiceDto> invoiceList;

        @Data
        public static class InvoiceDto {

            /**
             * 发票代码
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceNo;

            /**
             * 发票号码
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceCode;

            /**
             * 开票日期
             * 格式: yyyy-MM-dd HH:mm:ss
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateTimeIssued;

            /**
             * 销售方识别号
             * 非必填
             */
            @JSONField(name = "xsfsbh")
            private String sellerTaxNo;

            /**
             * 购买方识别号
             * 非必填
             */
            @JSONField(name = "gmfsbh")
            private String buyerTaxNo;

            /**
             * 申请人识别号
             * 必填
             */
            @JSONField(name = "sqrsbh")
            private String applyTaxNo;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 流水号
         */
        @JSONField(name = "lsh")
        private String taskId;

        /**
         * 处理明细信息
         */
        @JSONField(name = "clmxxx")
        private List<Detail> detailList;

        @Data
        public static class Detail {

            /**
             * 发票代码
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceNo;

            /**
             * 发票号码
             * 非必填
             */
            @JSONField(name = "fphm")
            private String invoiceCode;

            /**
             * 开票日期
             * 格式: yyyy-MM-dd HH:mm:ss
             * 非必填
             */
            @JSONField(name = "kprq")
            private String dateTimeIssued;

            /**
             * 销售方识别号
             * 非必填
             */
            @JSONField(name = "xsfsbh")
            private String sellerTaxNo;

            /**
             * 购买方识别号
             * 非必填
             */
            @JSONField(name = "gmfsbh")
            private String buyerTaxNo;

            /**
             * 申请受理状态
             * 非必须
             * 00：成功
             * 01：失败
             */
            @JSONField(name = "sqslzt")
            private String applyStatus;

            /**
             * 处理失败说明
             * 非必须
             * 申请受理状态为01：失败时记录
             */
            @JSONField(name = "clsbsm")
            private String failReason;
        }
    }
}
