package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhenmengying
 * @date 2023/1/16
 * @describe: 获取全电发票批量预赋码信息
 */
public class PostInvoiceNoSegmentMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 领用数量
         * 申领数量最大值为：5000
         */
        @JSONField(name = "lysl")
        private Integer quantity;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 发票起始号码
         */
        @JSONField(name = "fpqshm")
        private String startInvoiceNo;

        /**
         * 发票终止号码
         */
        @JSONField(name = "fpzzhm")
        private String endInvoiceNo;

        /**
         * 领用数量
         */
        @JSONField(name = "lysl")
        private Integer quantity;
    }
}
