package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhenmengying
 * @date 2023/2/9
 * @describe: 发票用途状态信息查询
 */
public class PostInvoicePurposeStatusMessage {

    @Data
    public static class Request {

        /**
         * 发票类型
         * 01-增值税专用发票
         * 02-货物运输业增值税专用发票
         * 03-机动车销售统一发票
         * 04-增值税普通发票
         * 08-增值税电子专用发票
         * 10-增值税电子普通发票
         * 11-卷式发票
         * 14-通行费发票
         * 15-二手车销售统一发票
         * 81-电子发票（增值税专用发票）
         * 82-电子发票（普通发票）
         * 83-机动车销售电子统一发票
         * 84-二手车销售电子统一发票
         * 85-纸质发票（增值税专用发票）
         * 86-纸质发票（普通发票）
         * 87-纸质发票（机动车销售统一发票）
         * 88-纸质发票（二手车销售统一发票）
         * 51-电子发票（铁路电子客票）
         * 61-电子发票（航空运输客票电子行程单）
         */
        @JSONField(name = "fplx")
        private String invoiceType;

        /**
         * 发票代码（非必须）
         * 全电发票发票代码可为空
         */
        @JSONField(name = "fpdm")
        private String invoiceCode;

        /**
         * 发票号码
         * 全电发票，发票号码20位
         */
        @JSONField(name = "fphm")
        private String invoiceNo;

        /**
         * 开票日期
         * YYYYMMDD
         */
        @JSONField(name = "kprq")
        private String dateIssued;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 发票代码
         * 全电发票发票代码可为空
         */
        @JSONField(name = "fpdm")
        private String invoiceCode;

        /**
         * 发票号码
         * 全电发票，发票号码20位
         */
        @JSONField(name = "fphm")
        private String invoiceNo;

        /**
         * 开票日期
         * YYYY-MM-DD HH:mm:ss
         */
        @JSONField(name = "kprq")
        private String dateTimeIssued;

        /**
         * 发票状态（非必须）
         * 0-正常
         * 2-作废
         * 3-已红冲
         * 7-部分红冲
         * 8-全额冲红
         */
        @JSONField(name = "fpzt")
        private String status;

        /**
         * 异常凭证状态（非必须）-风险状态
         * 01-正常
         * 02-异常凭证
         * 03-疑似异常凭证
         */
        @JSONField(name = "ycpzzt")
        private String riskStatus;

        /**
         * 红字锁定标识（非必须）
         * Y-锁定；N-未锁定
         */
        @JSONField(name = "hzsdbs")
        private String redLetterBlockFlag;

        /**
         * 发票用途（非必须）
         * 0-未使用
         * 1-已申请抵扣
         * 2-已申请退税
         * 3-已申请代办退税
         * 4-已勾选不抵扣（历史数据）
         * 5-已申请代办退税（历史数据）
         * 6-已申请不抵扣
         * 7-内销转出口
         * 8-出口转内销
         * 9-准予退税
         * 10-不予退税
         * 11-冬奥退税
         * 12-农产品加计扣除
         */
        @JSONField(name = "fpyt")
        private String vatUsageLabel;

        /**
         * 税收优惠标签（非必须）
         * 01-增值税即征即退
         * 02-冬奥会退税
         */
        @JSONField(name = "ssyhbq")
        private String taxPreFlag;

        /**
         * 入账状态（非必须）
         * 01-未入账
         * 02-已入账
         * 03-已入账撤销
         */
        @JSONField(name = "rzzt")
        private String entryStatus;

        /**
         * 成品油异常标识（非必须）
         * 9-正常
         * 1-成品油单价异常
         * 2-成品油超库存异常
         */
        @JSONField(name = "cpyycbs")
        private String oilAbnormalFlag;

        /**
         * 出口退税类代码（非必须）
         * 01-增值税专用发票可用于代办退税标签（仅用于代办退税）
         */
        @JSONField(name = "cktsldm")
        private String exportPolicyCode;
    }
}
