package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 查询全电红字确认单明细信息
 */
public class PostRedLetterDetailMessage {

    @Data
    public static class Request {

        /**
         * 红字确认单UUID
         */
        @JSONField(name = "uuid")
        private String redLetterUuid;

        /**
         * （销售方）统一社会信用代码/纳税人识别号/身份证件号码
         */
        @JSONField(name = "xsfnsrsbh")
        private String sellerTaxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 红字确认单UUID
         */
        @JSONField(name = "uuid")
        private String redLetterUuid;

        /**
         * 红字发票信息确认单编号
         */
        @JSONField(name = "hzfpxxqrdbh")
        private String redLetterNumber;

        /**
         * 录入方身份
         * 0：销方
         * 1：购方
         */
        @JSONField(name = "lrfsf")
        private String applyIdentity;

        /**
         * （销售方）统一社会信用代码/纳税人识别号/身份证件号码
         */
        @JSONField(name = "xsfnsrsbh")
        private String sellerTaxNo;

        /**
         * （销售方）名称
         */
        @JSONField(name = "xsfmc")
        private String sellerName;

        /**
         * （购买方）统一社会信用代码/纳税人识别号/身份证件号码（非必须）
         */
        @JSONField(name = "gmfnsrsbh")
        private String buyerTaxNo;

        /**
         * （购买方）名称
         */
        @JSONField(name = "gmfmc")
        private String buyerName;

        /**
         * 蓝字发票代码（非必须）
         */
        @JSONField(name = "lzfpdm")
        private String originalInvoiceCode;

        /**
         * 蓝字发票号码（非必须）
         */
        @JSONField(name = "lzfphm")
        private String originalInvoiceNo;

        /**
         * 是否纸质发票标志
         * Y：纸质发票
         * N：电子发票
         */
        @JSONField(name = "sfzzfpbz")
        private String paperInvoiceFlag;

        /**
         * 蓝字发票开票日期（非必须）
         * yyyy-MM-dd HH:mm:ss
         */
        @JSONField(name = "lzkprq")
        private String originalDateTimeIssued;

        /**
         * 蓝字发票合计金额（非必须）
         */
        @JSONField(name = "lzhjje")
        private BigDecimal originalAmountWithoutTax;

        /**
         * 蓝字发票合计税额（非必须）
         */
        @JSONField(name = "lzhjse")
        private BigDecimal originalTaxAmount;

        /**
         * 蓝字发票票种代码（非必须）
         * 01: 增值税专用发票
         * 02: 普通发票
         * 03: 机动车统一销售发票
         * 04: 二手车统一销售发票
         */
        @JSONField(name = "lzfppzDm")
        private String originalInvoiceType;

        /**
         * 蓝字发票特定要素类型代码（非必须）
         * 01：成品油发票
         * 02：稀土发票
         * 03：建筑服务发票
         * 04：货物运输服务发票
         * 05：不动产销售服务发票
         * 06：不动产租赁服务发票
         * 07：代收车船税
         * 08：通行费
         * 09：旅客运输服务发票
         * 10：医疗服务（住院）发票
         * 11：医疗服务（门诊）发票
         * 12：自产农产品销售发票
         * 13：拖拉机和联合收割机发票
         * 14：机动车
         * 15：二手车
         * 16：农产品收购发票
         * 17：光伏收购发票
         * 18：卷烟发票
         */
        @JSONField(name = "lzfpTdyslxDm")
        private String originalInvoiceStyleType;

        /**
         * 红字冲销金额
         */
        @JSONField(name = "hzcxje")
        private BigDecimal reverseAmountWithoutTax;

        /**
         * 红字冲销税额
         */
        @JSONField(name = "hzcxse")
        private BigDecimal reverseTaxAmount;

        /**
         * 红字发票冲红原因代码
         * 01：开票有误
         * 02：销货退回
         * 03：服务中止
         * 04：销售折让
         */
        @JSONField(name = "chyyDm")
        private String applyReason;

        /**
         * 红字确认单状态
         * 01：无需确认
         * 02：销方录入待购方确认
         * 03：购方录入待销方确认
         * 04：购销双方已确认
         * 05：作废（销方录入购方否认）
         * 06：作废（购方录入销方否认）
         * 07：作废（超72小时未确认）
         * 08：（发起方撤销）
         * 09：作废（确认后撤销）
         * 10作废（异常凭证）
         */
        @JSONField(name = "hzqrxxztDm")
        private String redLetterStatus;

        /**
         * 确认日期（非必须）
         * yyyy-MM-dd HH:mm:ss
         */
        @JSONField(name = "qrrq")
        private String confirmTime;

        /**
         * 已开具红字发票标志（非必须）
         * Y：已开具
         * N：未开具
         */
        @JSONField(name = "ykjhzfpbz")
        private String issuedFlag;

        /**
         * 红字发票号码
         */
        @JSONField(name = "hzfphm")
        private String redInvoiceNo;

        /**
         * 红字开票日期
         * yyyy-MM-dd HH:mm:ss
         */
        @JSONField(name = "hzkprq")
        private String redDateTimeIssued;

        /**
         * 有效标志
         * Y：有效
         * N：无效
         */
        @JSONField(name = "yxbz")
        private String validFlag;

        /**
         * 蓝字发票明细序号（非必须）
         */
        @JSONField(name = "lzmxxh")
        private Integer originalRowNum;

        @JSONField(name = "hzqrxxmxList")
        private List<Detail> details = new ArrayList<>();

        @Data
        public static class Detail {

            /**
             * 序号
             * 8位，从1开始。
             */
            @JSONField(name = "xh")
            private Integer rowNum;

            /**
             * 商品和服务税收分类合并编码
             */
            @JSONField(name = "sphfwssflhbbm")
            private String goodsTaxNo;

            /**
             * 货物或应税劳务、服务名称
             */
            @JSONField(name = "hwhyslwfwmc")
            private String itemSimpleName;

            /**
             * 商品服务简称
             */
            @JSONField(name = "spfwjc")
            private String itemShortName;

            /**
             * 项目名称
             */
            @JSONField(name = "xmmc")
            private String itemName;

            /**
             * 规格型号（非必须）
             */
            @JSONField(name = "ggxh")
            private String specifications;

            /**
             * 单位（非必须）
             * 如“数量”“单价”栏次非空，则本栏次必须非空
             */
            @JSONField(name = "dw")
            private String unit;

            /**
             * 单价（非必须）
             * 如“数量”“单位”栏次非空，则本栏次必须非空
             */
            @JSONField(name = "fpspdj")
            private String unitPrice;

            /**
             * 数量（非必须）
             * 如“单价”“单价”栏次非空，则本栏次必须非空
             */
            @JSONField(name = "fpspsl")
            private String quantity;

            /**
             * 金额
             */
            @JSONField(name = "je")
            private BigDecimal amountWithoutTax;

            /**
             * 税率
             */
            @JSONField(name = "sl1")
            private BigDecimal taxRate;

            /**
             * 税额
             */
            @JSONField(name = "se")
            private BigDecimal taxAmount;
        }
    }
}
