package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 查询税收分类编码信息
 */
public class PostTaxCodeMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码
         * 开票纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 时间戳
         * 格式：yyyyMMddHHmmss
         * 首次下载时为空；
         * 非首次下载时，传入上次下载返回的时间戳.格式：yyyymmdd
         */
        @JSONField(name = "sjc")
        private String timeStamp;

        /**
         * 省级税务机关代码
         */
        @JSONField(name = "sjswjgdm")
        private String provincialTaxAuthorityCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 时间戳
         * 格式：
         * yyyyMMddHHmmss
         * 用于增量下载
         */
        @JSONField(name = "sjc")
        private String timeStamp;

        /**
         * 总数量
         */
        @JSONField(name = "count")
        private Integer total;

        @JSONField(name = "ssbmList")
        private List<RateInfo> slzslList;

        @Data
        public static class RateInfo {
            /**
             * 父级编码
             */
            @JSONField(name = "fjbm")
            private String parentCode;

            /**
             * 商品和服务税收分类合并编码
             */
            @JSONField(name = "sphfwssflhbbm")
            private String goodsTaxNo;

            /**
             * 特定要素标签归类（非必须）
             * 01：成品油
             * 02：稀土
             * 03：建筑服务
             * 04：货物运输
             * 05：不动产销售
             * 06：不动产租赁
             * 07：代收车船使用税
             * 08：通行费
             * 09：旅客运输
             * 10：医疗服务
             * 11：农产品
             * 12：拖拉机和联合收割机
             * 13：机动车
             * 14：光伏收购
             * 15：卷烟
             */
            @JSONField(name = "tdyslxdm")
            private String originalInvoiceStyleType;

            /**
             * 差额征税（非必须）
             * Y：是
             * N：否
             */
            @JSONField(name = "cezs")
            private String deduction;

            /**
             * 不征税（非必须）
             * Y：是
             * N：否
             */
            @JSONField(name = "bzs")
            private String taxPreFlag;

            /**
             * 即征即退代码集合（非必须）
             * 01：增值税即征即退-软件产品
             * 02：增值税即征即退-资源综合利用产品
             * 03：增值税即征即退-管道运输服务
             * 04：增值税即征即退-有形动产融资租赁服务
             * 05：增值税即征即退-有形动产融资性售后回租服务
             * 06：增值税即征即退-新型墙体材料
             * 07：增值税即征即退-风力发电产品
             * 08：增值税即征即退-光伏发电产品
             * 09：增值税即征即退-动漫软件产品
             * 10：增值税即征即退-飞机维修劳务
             * 11：增值税即征即退-黄金
             * 12：增值税即征即退-铂金
             */
            @JSONField(name = "jzjtdm")
            private String vatRefundType;

            /**
             * 商品和服务名称
             */
            @JSONField(name = "sphfwmc")
            private String itemSimpleName;

            /**
             * 商品和服务分类简称
             */
            @JSONField(name = "sphfwfljc")
            private String itemShortName;

            /**
             * 说明（非必须）
             */
            @JSONField(name = "sm")
            private String remark;

            /**
             * 增值税税率
             * 取值返回是中文顿号连接的百分数。例如3%、5%
             */
            @JSONField(name = "zzssl")
            private String vatRate;

            /**
             * 征收率（非必须）
             * 取值返回是中文顿号连接的百分数。例如3%、5%
             */
            @JSONField(name = "zsl")
            private String taxRate;

            /**
             * 增值税特殊管理（非必须）
             */
            @JSONField(name = "zzstsgl")
            private String specialManagement;

            /**
             * 增值税政策依据（非必须）
             */
            @JSONField(name = "zzszcyj")
            private String policyBasis;

            /**
             * 增值税特殊内容代码（增值税减免税政策代码表、非必须）
             */
            @JSONField(name = "zzstsnrdm(zzsjmszcdmb)")
            private String specialCode;

            /**
             * 消费税管理（非必须）
             */
            @JSONField(name = "xfsgl")
            private String consumptionManagement;

            /**
             * 消费税政策依据（非必须）
             */
            @JSONField(name = "xfszcyj")
            private String consumptionPolicyBasis;

            /**
             * 消费税特殊内容代码（非必须）
             */
            @JSONField(name = "xfstsnrdm")
            private String consumptionSpecialCode;

            /**
             * 关键字（非必须）
             */
            @JSONField(name = "gjz")
            private String keywords;

            /**
             * 是否汇总项
             * Y：是
             * N：否
             */
            @JSONField(name = "sfhzx")
            private String summarizeItemFlag;

            /**
             * 对应统计局编码（2011年版）或国民行业代码（非必须）
             */
            @JSONField(name = "dytjjbm")
            private String officialCode;

            /**
             * 海关进出口商品品目（非必须）
             */
            @JSONField(name = "hgjcksppm")
            private String importExportItem;

            /**
             * 启用日期
             * 格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "qyrq")
            private String startDate;

            /**
             * 停用日期（非必须）
             * 格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "tyrq")
            private String endDate;

            /**
             * 行业代码（非必须）
             * 主行业代码特定征收部门可空
             */
            @JSONField(name = "hydm")
            private String industryCode;

            /**
             * 对应的行业（非必须）
             */
            @JSONField(name = "dydhy")
            private String industry;

            /**
             * 行业对应的征收品目一（非必须）
             */
            @JSONField(name = "hydydzspm1")
            private String collectionItems1;

            /**
             * 行业对应的征收名称一（非必须）
             */
            @JSONField(name = "hydydzsmc1")
            private String collectionName1;

            /**
             * 行业对应的征收品目二（非必须）
             */
            @JSONField(name = "hydydzspm2")
            private String collectionItems2;

            /**
             * 行业对应的征收名称二（非必须）
             */
            @JSONField(name = "hydydzsmc2")
            private String collectionName2;
        }
    }

}
