package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 查询可用税率信息
 */
public class PostTaxRateMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 总数量
         */
        @JSONField(name = "count")
        private Integer total;

        @JSONField(name = "slzslList")
        private List<TaxRateInfo> taxRateList;

        @Data
        public static class TaxRateInfo {

            /**
             * 参数性质
             * 1：税率
             * 2：征收率
             */
            @JSONField(name = "csxz")
            private String paraProperties;

            /**
             * 税率征收率
             */
            @JSONField(name = "slzsl")
            private BigDecimal taxRate;

            /**
             * 原税率标志
             * Y：有原税率
             * N：无原税率
             */
            @JSONField(name = "yslbz")
            private String originalTaxRateFlag;

            /**
             * 对应原税率（非必须）
             * 百分比形式、逗号连接
             */
            @JSONField(name = "dyysl")
            private String originalTaxRate;

            /**
             * 参数状态
             * 0：启用
             * 1：停用
             */
            @JSONField(name = "cszt")
            private String paraFlag;

            /**
             * 有效期起
             * 时间格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "yxqq")
            private String startDate;

            /**
             * 有效期止（非必须）
             * 时间格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "yxqz")
            private String endDate;

            /**
             * 停用日期（非必须）
             * 时间格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "tyrq")
            private String stopDate;
        }
    }

}
