package com.xforceplus.taxware.leqi.kernel.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 查询纳税人风险信息
 */
public class PostTaxpayerRiskMessage {

    @Data
    public static class Request {
        /**
         * 纳税人识别号/统一社会信用代码
         * 开票纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 风险纳税人类型（非必须）
         * 空：非风险纳税人
         * 01：Ⅰ类（高风险）纳税人
         * 02：Ⅱ类（中风险）纳税人
         * 03：Ⅲ类（低风险）纳税人
         * 04：Ⅳ类（无风险）纳税人
         */
        @JSONField(name = "fxnsrlx")
        private String taxpayerRiskType;

        /**
         * 纳税人信用等级
         * A
         * B
         * C
         * D
         * M
         */
        @JSONField(name = "nsrxydj")
        private String taxpayerRiskLevel;

        /**
         * 纳税人预警级别（非必须）
         * 空：无预警
         * 01：红色预警
         * 02：黄色预警
         * 03：蓝色预警
         */
        @JSONField(name = "nsryjjb")
        private String taxpayerWarningLevel;

        /**
         * 风险纳税人标志
         * Y：风险纳税人
         * N：正常纳税人
         */
        @JSONField(name = "fxnsrbz")
        private String taxpayerRiskFlag;
    }
}

