package com.xforceplus.taxware.leqi.kernel.contract.model.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Auther lv
 * @Date 2023/3/3
 */
public enum NaturalSystemEnums {

    /**
     * 查询纳税人基本信息
     */
    TAXPAYER_INFO("taxpayerInfo","CXNSRJBXX"),
    /**
     * 查询纳税人风险信息
     */
    TAXPAYER_RISK_INFO("taxpayerRisk","CXNSRFXXX"),
    /**
     * 查询可用税率信息
     */
    TAX_RATE_INFO("taxRate","CXKYSL"),
    /**
     * 查询税收分类编码信息
     */
    TAX_CODE_INFO("taxCode","CXSSFLBM"),
    /**
     * 查询授信额度
     */
    CREDIT_LINE("creditLine","CXSXED"),
    /**
     * 下载/退回授信额度
     */
    DOWNLOAD_CREDIT_LINE("downloadSendBackCreditLine","XZTHSXED"),
    /**
     * 调整授信额度有效期
     */
    CREDIT_LINE_PERIOD("creditLinePeriod","TZSXEDYXQ"),
    /**
     * 获取全电发票批量预赋码信息
     */
    INVOICE_NO_SEGMENT("invoiceNoSegment","QDFPPLFM"),
    /**
     * 全电发票上传
     */
    INVOICE_UPLOAD("invoiceUpload","QDFPSC"),
    /**
     * 查询全电发票上传结果
     */
    INVOICE_UPLOAD_RESULT("invoiceUploadResult","CXQDFPSCJG"),
    /**
     * 全电红字确认单申请
     */
    RED_LETTER_APPLY("redLetterApply","QDHZQRDSQ"),
    /**
     * 全电红字确认单确认
     */
    RED_LETTER_CONFIRM("redLetterConfirm","QDHZQRDQR"),
    /**
     * 查询全电红字确认单列表查询
     */
    RED_LETTER_LIST("redLetterList","CXQDHZQRDLB"),
    /**
     * 查询全电红字确认单明细查询
     */
    RED_LETTER_DETAIL("redLetterDetail","CXQDHZQRDMX"),
    /**
     * 全电发票xml文件下载
     */
    INVOICE_XML("invoiceXml","QDQDFPWJSQXZ"),
    /**
     * 全电发票xml文件下载结果
     */
    INVOICE_XML_RESULT("invoiceXmlResult","QDQDFPWJSQJGFK"),
    /**
     * 发票用途状态信息查询
     */
    INVOICE_PURPOSE_STATUS("invoicePurposeStatus","PLFPZTXXCX");

    private String name;
    private String serviceCode;

    NaturalSystemEnums(String name, String serviceCode) {
        this.name = name;
        this.serviceCode = serviceCode;
    }

    public static NaturalSystemEnums fromServiceCode(String serviceCode) {
        final var values = NaturalSystemEnums.values();
        return Arrays.stream(values).filter(naturalSystemEnums -> Objects.equals(serviceCode, naturalSystemEnums.serviceCode)).findFirst().orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }
}
