/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.leqi.kernel.contract.model.enums;

import java.util.Arrays;
import java.util.Objects;

public enum NaturalSystemEnums {
    TAXPAYER_INFO("taxpayerInfo", "CXNSRJBXX"),
    TAXPAYER_RISK_INFO("taxpayerRisk", "CXNSRFXXX"),
    TAX_RATE_INFO("taxRate", "CXKYSL"),
    TAX_CODE_INFO("taxCode", "CXSSFLBM"),
    CREDIT_LINE("creditLine", "CXSXED"),
    DOWNLOAD_CREDIT_LINE("downloadSendBackCreditLine", "XZTHSXED"),
    CREDIT_LINE_PERIOD("creditLinePeriod", "TZSXEDYXQ"),
    INVOICE_NO_SEGMENT("invoiceNoSegment", "QDFPPLFM"),
    INVOICE_UPLOAD("invoiceUpload", "QDFPSC"),
    INVOICE_UPLOAD_RESULT("invoiceUploadResult", "CXQDFPSCJG"),
    RED_LETTER_APPLY("redLetterApply", "QDHZQRDSQ"),
    RED_LETTER_CONFIRM("redLetterConfirm", "QDHZQRDQR"),
    RED_LETTER_LIST("redLetterList", "CXQDHZQRDLB"),
    RED_LETTER_DETAIL("redLetterDetail", "CXQDHZQRDMX"),
    INVOICE_XML("invoiceXml", "FPWJSQXZ"),
    INVOICE_XML_RESULT("invoiceXmlResult", "FPWJSQJGFK"),
    INVOICE_PURPOSE_STATUS("invoicePurposeStatus", "FPZTXXCX"),
    INVOICE_DOWNLOAD("invoiceDownload", "PLFPXZSQ"),
    INVOICE_DOWNLOAD_RESULT("invoiceDownloadResult", "PLFPXZSQFK"),
    INVOICE_DOWNLOAD_INCREMENT("invoiceDownloadIncrement", "CXZLXZFPXX"),
    EXPORT_TO_DOMESTIC_SALES_INVOICE("exportToDomesticSalesInvoice", "PLCKZNXFPXXCX"),
    EXPORT_TO_DOMESTIC_SALES_CUSTOMS_PAYMENT("exportToDomesticSalesCustomsPayment", "PLCKZNXHGJKSXXCX"),
    VAT_TAX_PAYMENT_VOUNCHER("vatTaxPaymentVoucher", "PLZZSDKDJWSPZXZSQ"),
    VAT_TAX_PAYMENT_VOUNCHER_RESULT("vatTaxPaymentVoucherResult", "PLZZSDKDJWSPZXZSQFK"),
    VAT_TAX_PAYMENT_VOUNCHER_INCREMENT("vatTaxPaymentVoucherIncrement", "CXZLXZZZSDKDJWSPZXX"),
    EXCISE_TAX_PAYMENT_VOUCHER("exciseTaxPaymentVoucher", "PLXFSDKDJWSPZXZSQ"),
    EXCISE_TAX_PAYMENT_VOUCHER_RESULT("exciseTaxPaymentVoucherResult", "PLXFSDKDJWSPZXZSQFK"),
    EXCISE_TAX_PAYMENT_VOUCHER_INCREMENT("exciseTaxPaymentVoucherIncrement", "CXZLXZXFSDKDJWSPZXX"),
    CUSTOMS_PAYMENT("customsPayment", "PLHGJKSXZSQ"),
    CUSTOMS_PAYMENT_RESULT("customsPaymentResult", "PLHGJKSXZSQFK"),
    CUSTOMS_PAYMENT_INCREMENT("customsPaymentIncrement", "CXZLXZHGJKSXX");

    private String name;
    private String serviceCode;

    private NaturalSystemEnums(String name, String serviceCode) {
        this.name = name;
        this.serviceCode = serviceCode;
    }

    public static NaturalSystemEnums fromServiceCode(String serviceCode) {
        NaturalSystemEnums[] values = NaturalSystemEnums.values();
        return Arrays.stream(values).filter(naturalSystemEnums -> Objects.equals(serviceCode, naturalSystemEnums.serviceCode)).findFirst().orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }
}

