package com.xforceplus.taxware.leqi.kernel.contract.model.base.invoice;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/18
 * @Description 增值税普通发票（通行费）数据
 *
 *     14：通行费发票
 */
@Data
public class InvoiceVatGeneralToll {
    /**
     * 发票代码
     * 长度：12
     * 必需
     */
    @JSONField(name = "fpdm")
    private String invoiceCode;

    /**
     * 发票号码
     * 长度：20
     * 必需
     */
    @JSONField(name = "fphm")
    private String invoiceNo;

    /**
     * 报税纳税人识别号
     * 长度：20
     * 必填
     */
    @JSONField(name = "bsNsrsbh")
    private String taxNo;

    /**
     * 开票日期
     * 格式: yyyy-MM-dd HH:mm:ss
     * 长度：19
     * 必需
     */
    @JSONField(name = "kprq")
    private String dateTimeIssued;

    /**
     * 特殊票种
     * 长度：2
     * 非必需
     * 06：通行费（可抵扣）
     * 07：通行费（不可抵扣）
     */
    @JSONField(name = "tspz")
    private String specialType;

    /**
     * 发票状态标识
     * 长度：1
     * 必需
     * 0：正数票
     * 1：负数票
     * 2：空白作废发票
     * 3：正数作废发票
     * 4：负数作废发票
     */
    @JSONField(name = "fpztbz")
    private String status;

    /**
     * 税控码
     * 长度：200
     * 非必需
     */
    @JSONField(name = "skm")
    private String cipherText;

    /**
     * 校验码
     * 长度：32
     * 非必需
     */
    @JSONField(name = "jym")
    private String checkCode;

    /**
     * 销售方识别号
     * 长度：20
     * 必需
     */
    @JSONField(name = "xfsbh")
    private String sellerTaxNo;

    /**
     * 销售方名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "xfmc")
    private String sellerName;

    /**
     * 销售方地址电话
     * 长度：190
     * 非必需
     */
    @JSONField(name = "xsfdzdh")
    private String sellerAddressTelInfo;

    /**
     * 销售方银行账号
     * 长度：300
     * 非必需
     */
    @JSONField(name = "xsfyhzh")
    private String sellerBankInfo;

    /**
     * 购买方税号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "gfsbh")
    private String buyerTaxNo;

    /**
     * 购买方名称
     * 长度：300
     * 必需
     */
    @JSONField(name = "gfmc")
    private String buyerName;

    /**
     * 购买方地址电话
     * 长度：190
     * 非必需
     */
    @JSONField(name = "gmfdzdh")
    private String buyerAddressTelInfo;

    /**
     * 购买方银行账号
     * 长度：300
     * 非必需
     */
    @JSONField(name = "gmfyhzh")
    private String buyerBankInfo;

    /**
     * 代开发票真实销售方识别号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "dkXsfsbh")
    private String deputyTaxNo;

    /**
     * 代开发票真实销售方名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "dkXsfmc")
    private String deputyName;

    /**
     * 完税凭证号
     * 长度：200
     * 非必需
     */
    @JSONField(name = "wspzh")
    private String taxPaidProof;

    /**
     * 作废日期
     * 长度：19
     * 非必需
     * YYYY-MM-DD HH:mm:ss
     */
    @JSONField(name = "zfrq")
    private String cancellationTime;

    /**
     * 金额
     * 非必需
     * 单位：元
     */
    @JSONField(name = "je")
    private BigDecimal amountWithoutTax;

    /**
     * 税额
     * 非必需
     * 单位：元
     */
    @JSONField(name = "se")
    private BigDecimal taxAmount;

    /**
     * 税率
     * 非必需
     */
    @JSONField(name = "slv")
    private BigDecimal taxRate;

    /**
     * 价税合计
     * 必需
     * 单位：元
     */
    @JSONField(name = "jshj")
    private BigDecimal amountWithTax;

    /**
     * 备注
     * 长度：610
     * 非必需
     */
    @JSONField(name = "bz")
    private String remark;

    /**
     * 不征税金额
     * 非必需
     */
    @JSONField(name = "bzsje")
    private BigDecimal amountNonTaxable;

    @JSONField(name = "hwxx")
    private List<Detail> detailList;

    @Data
    public static class Detail {
        /**
         * 货物明细序号
         * 非必需
         */
        @JSONField(name = "mxxh")
        private Integer rowNum;

        /**
         * 货物名称
         * 长度：310
         * 非必需
         */
        @JSONField(name = "mc")
        private String itemName;

        /**
         * 规格型号
         * 长度：64
         * 非必需
         */
        @JSONField(name = "ggxh")
        private String specifications;

        /**
         * 计量单位
         * 长度：52
         * 非必需
         */
        @JSONField(name = "jldw")
        private String unit;

        /**
         * 数量
         * 长度：25
         * 非必需
         */
        @JSONField(name = "sl")
        private String quantity;

        /**
         * 单价
         * 长度：25
         * 非必需
         */
        @JSONField(name = "dj")
        private String unitPrice;

        /**
         * 税率
         * 非必需
         */
        @JSONField(name = "slv")
        private BigDecimal taxRate;

        /**
         * 税额
         * 必需
         */
        @JSONField(name = "se")
        private BigDecimal taxAmount;

        /**
         * 金额
         * 必需
         */
        @JSONField(name = "je")
        private BigDecimal amountWithoutTax;

        /**
         * 商品编码
         * 长度：45
         * 非必需
         */
        @JSONField(name = "spbm")
        private String goodsTaxNo;
    }
}
