package com.xforceplus.taxware.leqi.kernel.contract.model.base.invoice;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/18
 * @Description 增值税普通发票（卷式）数据
 *
 *     11：卷式发票
 */
@Data
public class InvoiceVatGeneralVolume {
    /**
     * 发票代码
     * 长度：12
     * 必需
     */
    @JSONField(name = "fpdm")
    private String invoiceCode;

    /**
     * 发票号码
     * 长度：20
     * 必需
     */
    @JSONField(name = "fphm")
    private String invoiceNo;

    /**
     * 报税纳税人识别号
     * 长度：20
     * 必填
     */
    @JSONField(name = "bsNsrsbh")
    private String taxNo;

    /**
     * 开票日期
     * 格式: yyyy-MM-dd HH:mm:ss
     * 长度：19
     * 必需
     */
    @JSONField(name = "kprq")
    private String dateTimeIssued;

    /**
     * 销售方识别号
     * 长度：20
     * 必需
     */
    @JSONField(name = "xfsbh")
    private String sellerTaxNo;

    /**
     * 销售方名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "xfmc")
    private String sellerName;

    /**
     * 购买方税号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "gfsbh")
    private String buyerTaxNo;

    /**
     * 购买方名称
     * 长度：300
     * 必需
     */
    @JSONField(name = "gfmc")
    private String buyerName;

    /**
     * 代开发票真实销售方识别号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "dkXsfsbh")
    private String deputyTaxNo;

    /**
     * 代开发票真实销售方名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "dkXsfmc")
    private String deputyName;

    /**
     * 完税凭证号
     * 长度：200
     * 非必需
     */
    @JSONField(name = "wspzh")
    private String taxPaidProof;

    /**
     * 作废日期
     * 长度：19
     * 非必需
     * YYYY-MM-DD HH:mm:ss
     */
    @JSONField(name = "zfrq")
    private String cancellationTime;

    /**
     * 特殊票种
     * 长度：2
     * 非必需
     * 08：成品油发票；
     */
    @JSONField(name = "tspz")
    private String specialType;

    /**
     * 发票状态标识
     * 长度：1
     * 必需
     * 0：正数票
     * 1：负数票
     * 2：空白作废发票
     * 3：正数作废发票
     * 4：负数作废发票
     */
    @JSONField(name = "fpztbz")
    private String status;

    /**
     * 金额
     * 必需
     * 单位：元
     */
    @JSONField(name = "je")
    private BigDecimal amountWithoutTax;

    /**
     * 税额
     * 必需
     * 单位：元
     */
    @JSONField(name = "se")
    private BigDecimal taxAmount;

    /**
     * 税率
     * 必需
     */
    @JSONField(name = "slv")
    private BigDecimal taxRate;

    /**
     * 价税合计
     * 必需
     * 单位：元
     */
    @JSONField(name = "jshj")
    private BigDecimal amountWithTax;

    /**
     * 备注
     * 长度：610
     * 非必需
     */
    @JSONField(name = "bz")
    private String remark;

    /**
     * 校验码
     * 长度：32
     * 非必需
     */
    @JSONField(name = "jym")
    private String checkCode;

    /**
     * 明细条数
     * 长度：30
     * 非必需
     */
    @JSONField(name = "mxts")
    private Integer detailCount;

    /**
     * 不征税金额
     * 非必需
     */
    @JSONField(name = "bzsje")
    private BigDecimal amountNonTaxable;

    /**
     * 销售方地址电话
     * 长度：190
     * 非必需
     */
    @JSONField(name = "xsfdzdh")
    private String sellerAddressTelInfo;

    /**
     * 销售方银行账号
     * 长度：300
     * 非必需
     */
    @JSONField(name = "xsfyhzh")
    private String sellerBankInfo;

    /**
     * 购买方地址电话
     * 长度：190
     * 非必需
     */
    @JSONField(name = "gmfdzdh")
    private String buyerAddressTelInfo;

    /**
     * 购买方银行账号
     * 长度：300
     * 非必需
     */
    @JSONField(name = "gmfyhzh")
    private String buyerBankInfo;

    @JSONField(name = "hwxx")
    private List<Detail> detailList;

    @Data
    public static class Detail {
        /**
         * 货物明细序号
         * 必需
         */
        @JSONField(name = "mxxh")
        private Integer rowNum;

        /**
         * 项目
         */
        @JSONField(name = "xm")
        private String itemName;

        /**
         * 数量
         * 长度：25
         * 非必需
         */
        @JSONField(name = "sl")
        private String quantity;

        /**
         * 不含税单价
         * 长度：25
         * 必需
         */
        @JSONField(name = "dj")
        private String unitPrice;

        /**
         * 不含税金额
         * 必需
         */
        @JSONField(name = "je")
        private BigDecimal amountWithoutTax;

        /**
         * 含税单价
         * 长度：25
         * 必需
         */
        @JSONField(name = "hsdj")
        private String unitPriceWithTax;

        /**
         * 含税金额
         * 必需
         */
        @JSONField(name = "hsje")
        private BigDecimal amountWithTax;

        /**
         * 税率
         * 必需
         */
        @JSONField(name = "slv")
        private BigDecimal taxRate;

        /**
         * 税额
         * 必需
         */
        @JSONField(name = "se")
        private BigDecimal taxAmount;

        /**
         * 商品编码
         * 长度：45
         * 必需
         */
        @JSONField(name = "spbm")
        private String goodsTaxNo;
    }
}
