package com.xforceplus.taxware.leqi.kernel.contract.model.buyer;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description: 获取当前税款所属期发票抵扣勾选处理结果
 */
public class PostCurrentTaxPeriodInvoiceDeduction {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 非必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 查询页码
         * int
         * 不传默认为 1，可根据返回的总页数调整所需要查询的页码数据
         */
        @JSONField(name = "cxym")
        private String pageNumber;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 总页数
         * int
         * 必需
         */
        @JSONField(name = "zys")
        private String totalPageCount;

        /**
         * 当前页码
         * int
         * 必需
         * 每页 200 条
         */
        @JSONField(name = "dqym")
        private String pageSize;

        @JSONField(name = "fpmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必需
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必需
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必需
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 税款所属期
             * 格式 YYYYMM，抵扣成功时该字段不为空
             * 长度：6
             * 非必需
             */
            @JSONField(name = "skssq")
            private String taxPeriod;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 勾选时间
             * 长度：8
             * 非必需
             * 撤销勾选时，此字段为空
             * YYYYMMDD
             */
            @JSONField(name = "gxsj")
            private String deductionDate;

            /**
             * 发票状态
             * 长度：1
             * 非必需
             * 处理结果为
             * 03：该票异常无法勾选时，根据实际情况反馈此码值。
             * 0：正常
             * 1：失控
             * 2：作废
             * 3：已红冲
             * 7：部分冲红
             * 8：全额红冲
             */
            @JSONField(name = "fpzt")
            private String status;

            /**
             * 是否异常凭证
             * 长度：2
             * 非必填
             * 01：正常
             * 02：异常凭证
             * 03：疑似异常凭证
             */
            @JSONField(name = "sfycpz")
            private String abnormalStatus;

            /**
             * 锁定状态
             * 长度：2
             * 非必需
             * 01：未锁定
             * 02：已锁定
             */
            @JSONField(name = "sdzt")
            private String blockStatus;

            /**
             * 当前勾选用途
             * 长度：2
             * 非必填
             * 1：已勾选抵扣
             * 4：已勾选不抵扣（历史数据）
             * 6：已申请不抵扣
             * 11：冬奥退税
             */
            @JSONField(name = "hxyt")
            private String deductionPurpose;
        }
    }
}
