package com.xforceplus.taxware.leqi.kernel.contract.model.buyer;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description: 申请确认抵扣统计
 */
public class PostDeductionStatisticsConfirmApply {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 非必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 申请标志
         * 长度：1
         * 必需
         * 1：申请统计
         * 2：撤销统计
         */
        @JSONField(name = "sqbz")
        private String applyFlag;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 非必需
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 发票异常信息 fpycxx
         * 存在异常发票信息时记录数据
         */
        @JSONField(name = "fpycxx")
        private List<ErrorDetail> errorDetailList;

        /**
         * 海关缴款书异常信息 hgjksycxx
         * 存在异常发票信息时记录数据
         */
        @JSONField(name = "hgjksycxx")
        private List<CustomsPaymentErrorDetail> customsPaymentErrorDetailList;

        @Data
        public static class ErrorDetail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 非必需
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必需
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 非必需
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 税款所属期
             * YYYYMM
             * 长度：6
             * 非必需
             */
            @JSONField(name = "skssq")
            private String taxPeriod;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 勾选时间
             * 长度：8
             * 非必需
             * 撤销勾选时，此字段为空
             * YYYYMMDD
             */
            @JSONField(name = "gxsj")
            private String deductionDate;

            /**
             * 发票状态
             * 长度：1
             * 非必需
             * 0：正常
             * 1：失控
             * 2：作废
             * 3：已红冲
             * 7：部分冲红
             * 8：全额红冲
             */
            @JSONField(name = "fpzt")
            private String status;

            /**
             * 是否异常凭证
             * 长度：2
             * 非必填
             * 01：正常
             * 02：异常凭证
             * 03：疑似异常凭证
             */
            @JSONField(name = "sfycpz")
            private String abnormalStatus;

            /**
             * 锁定状态
             * 长度：2
             * 非必需
             * 01：未锁定
             * 02：已锁定
             */
            @JSONField(name = "sdzt")
            private String blockStatus;
        }

        @Data
        public static class CustomsPaymentErrorDetail {
            /**
             * 缴款书号码
             * 长度：22
             * 非必需
             */
            @JSONField(name = "jkshm")
            private String customsPaymentNo;

            /**
             * 填发日期
             * 长度：8
             * 非必需
             * YYYYMMDD
             */
            @JSONField(name = "tfrq")
            private String dateIssued;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必需
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 税款所属期
             * 长度：6
             * 非必需
             * YYYYMM
             */
            @JSONField(name = "skssq")
            private String taxPeriod;

            /**
             * 勾选时间
             * 长度：8
             * 非必需
             * 撤销勾选时，此字段为空
             * YYYYMMDD
             */
            @JSONField(name = "gxsj")
            private String deductionDate;

            /**
             * 异常状态代码
             * 长度：2
             * 非必需
             * 01：对方重号,
             * 对方申请核对
             * 02：核查后允
             * 许该企业使用
             * 03：核查后不
             * 允许该企业使
             * 用
             */
            @JSONField(name = "ycztDm")
            private String abnormalStatusCode;
        }
    }
}
