package com.xforceplus.taxware.leqi.kernel.contract.model.buyer;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description: 查询确认统计处理结果
 */
public class PostDeductionStatisticsConfirmApplyResult {
    @Data
    public static class Request {

        /**
         * 批次流水号
         * 长度：30
         * 必需
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 必需
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 当前统计确认状态
         * 长度：2
         * 必需
         * 01：处理成功（统计、撤销）
         * 07：确认失败，未申请统计
         * 08：确认失败，不能重复确认
         * 04：税号不存在
         * 09：不符合确认条件（当前月与属期相等时）
         * 10：已确认统计不能撤销（备注：不能直接撤销已统计数据，需要先撤销确认申请）
         */
        @JSONField(name = "jgzt")
        private String statisticsStatusConfirm;
    }
}
