package com.xforceplus.taxware.leqi.kernel.contract.model.buyer;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description: 查询增值税代扣代缴完税凭证抵扣勾选处理结果
 */
public class PostVatTaxPaymentVoucherDeductionUploadResult {
    @Data
    public static class Request {
        /**
         * 批次流水号
         * 长度：32
         * 必需
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 必需
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 扣缴义务人识别号
         * 长度：30
         * 必需
         */
        @JSONField(name = "kjywrsbh")
        private String taxNo;

        @JSONField(name = "dkdjmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 代扣代缴完税凭证号
             * 长度：22
             * 必需
             */
            @JSONField(name = "dkdjwspzh")
            private String taxPaidProof;

            /**
             * 填发日期
             * 长度：8
             * 必需
             * YYYYMMDD
             */
            @JSONField(name = "tfrq")
            private String dateIssued;

            /**
             * 被扣缴义务人统一社会信用代码/纳税人识别号
             * 长度：30
             * 必需
             */
            @JSONField(name = "bkjnsrsbh")
            private String taxNo;

            /**
             * 税款所属期
             * 格式YYYYMM，抵扣成功时该字段不为空
             * 长度：6
             * 非必填
             */
            @JSONField(name = "skssq")
            private String taxPeriod;

            /**
             * 处理结果
             * 长度：2
             * 非必需
             * 01：勾选（撤销）成功
             * 02：查无此票
             * 03：该票异常无法勾选
             * 04：该票已经逾期无法认证
             * 06：已勾选无法重复勾选
             * 07：未到期发票不可勾选（开票月份大于当前属期
             * 11：低版本发票
             * 12：机动车异常发票
             * 13：该票号码重复
             * 99：其它
             */
            @JSONField(name = "cljg")
            private String returnStatus;

            /**
             * 勾选时间
             * 长度：8
             * 非必需
             * 撤销勾选时，此字段为空
             * YYYYMMDD
             */
            @JSONField(name = "gxsj")
            private String deductionDate;

            /**
             * 当前勾选用途
             * 长度：2
             * 非必需
             * 处理结果为06：已勾选无法重复勾选时，根据实际情况反馈此码值。
             * 1：已申请抵扣
             * 2：已申请退税
             * 3：已申请代办退税
             * 4：已勾选不抵扣（历史数据）
             * 5：已申请代办退税（历史数据）
             * 6：已申请不抵扣
             */
            @JSONField(name = "hxyt")
            private String deductionPurpose;
        }
    }
}
