package com.xforceplus.taxware.leqi.kernel.contract.model.collection;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lvwenjing
 * @date 2023/4/21
 * @describe: 发票风险信息查询
 */
public class PostInvoiceRiskMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码
         * 长度：30
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 发票类型
         * 长度：2
         * 01:增值税专用发票
         * 02:货物运输业增值税专用发票
         * 03:机动车销售统一发票
         * 04:增值税普通发票
         * 08:增值税电子专用发票
         * 10:增值税电子普通发票
         * 11:卷式发票
         * 14:通行费发票
         * 15:二手车销售统一发票
         * 81:电子发票(增值税专用发票)
         * 82:电子发票(普通发票)
         * 85:纸质发票(增值税专用发票)
         * 86:纸质发票(普通发票)
         * 51:电子发票(铁路电子客票)
         * 61:电子发票(航空运输客票电子行程单)
         * */
        @JSONField(name = "fplx")
        private String invoiceType;

        /**
         * 起始日期
         * 长度：8:YYYYMMDD(认定异常日期, 起止日期不能跨月)
         */
        @JSONField(name = "qsrq")
        private String startDate;

        /**
         * 终止日期
         * 长度：8:YYYYMMDD(认定异常日期，起止日期不能跨越月)
         */
        @JSONField(name = "zzrq")
        private String endDate;

        /**
         * 每页数量（非必须）
         */
        @JSONField(name = "pagesize")
        private Integer pageSize;

        /**
         * 页码（非必须）初始页码1
         */
        @JSONField(name = "currpage")
        private Integer pageNumber;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 总数量
         * 长度：10
         */
        @JSONField(name = "count")
        private String count;

        @JSONField(name = "fptxxxmx")
        private List<Invoice> invoiceList;

        @Data
        public static class Invoice {
            /**
             * 数字化电子发票发票代码可为空
             * 长度：12
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 数字化电子发票，发票号码20位
             */
            @JSONField(name = "fphm")
            private String invoiceNo;


            /**
             * 开票日期
             * 格式：
             * yyyy-MM-dd HH:mm:ss
             */
            // @NotNull 赋码之前为空
            @JSONField(name = "kprq")
            private String dateTimeIssued;

            /**
             * 发票状态（非必须）
             * 0:正常
             * 2:作废
             * 3:已红冲
             * 7:部分红冲
             * 8:全额冲红
             */
            @JSONField(name = "fpzt")
            private String status;

            /**
             * 异常凭证状态（非必须）-风险状态
             * 01-正常
             * 02-异常凭证
             * 03-疑似异常凭证
             */
            @JSONField(name = "ycpzzt")
            private String riskStatus;

            /**
             * 变更日期
             * YYYY-MM-DD
             */
            @JSONField(name = "bgrq")
            private String changeDate;

        }
    }
}
