package com.xforceplus.taxware.leqi.kernel.contract.model.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Auther lv
 * @Date 2023/3/3
 */
public enum NaturalSystemEnums {

    /**
     * 查询纳税人基本信息
     */
    TAXPAYER_INFO("taxpayerInfo","CXNSRJBXX"),
    /**
     * 查询纳税人风险信息
     */
    TAXPAYER_RISK_INFO("taxpayerRisk","CXNSRFXXX"),
    /**
     * 查询可用税率信息
     */
    TAX_RATE_INFO("taxRate","CXKYSL"),
    /**
     * 查询税收分类编码信息
     */
    TAX_CODE_INFO("taxCode","CXSSFLBM"),
    /**
     * 查询授信额度
     */
    CREDIT_LINE("creditLine","CXSXED"),
    /**
     * 下载/退回授信额度
     */
    DOWNLOAD_CREDIT_LINE("downloadSendBackCreditLine","XZTHSXED"),
    /**
     * 调整授信额度有效期
     */
    CREDIT_LINE_PERIOD("creditLinePeriod","TZSXEDYXQ"),
    /**
     * 获取全电发票批量预赋码信息
     */
    INVOICE_NO_SEGMENT("invoiceNoSegment","QDFPPLFM"),
    /**
     * 全电发票上传
     */
    INVOICE_UPLOAD("invoiceUpload","QDFPSC"),
    /**
     * 查询全电发票上传结果
     */
    INVOICE_UPLOAD_RESULT("invoiceUploadResult","CXQDFPSCJG"),
    /**
     * 全电红字确认单申请
     */
    RED_LETTER_APPLY("redLetterApply","QDHZQRDSQ"),
    /**
     * 全电红字确认单确认
     */
    RED_LETTER_CONFIRM("redLetterConfirm","QDHZQRDQR"),
    /**
     * 查询全电红字确认单列表查询
     */
    RED_LETTER_LIST("redLetterList","CXQDHZQRDLB"),
    /**
     * 查询全电红字确认单明细查询
     */
    RED_LETTER_DETAIL("redLetterDetail","CXQDHZQRDMX"),
    /**
     * 全电发票xml文件下载
     */
    INVOICE_XML("invoiceXml","FPWJSQXZ"),
    /**
     * 全电发票xml文件下载结果
     */
    INVOICE_XML_RESULT("invoiceXmlResult","FPWJSQJGFK"),
    /**
     * 发票风险状态信息查询
     */
    INVOICE_RISK_STATUS("invoiceRiskStatus","FPTSTXXXCX"),
    /**
     * 发票用途状态信息查询
     */
    INVOICE_PURPOSE_STATUS("invoicePurposeStatus","FPZTXXCX"),
    /**
     * 发票批量下载
     */
    INVOICE_DOWNLOAD("invoiceDownload","PLFPXZSQ"),
    /**
     * 发票批量下载结果
     */
    INVOICE_DOWNLOAD_RESULT("invoiceDownloadResult","PLFPXZSQFK"),
    /**
     * 发票增量下载
     */
    INVOICE_DOWNLOAD_INCREMENT("invoiceDownloadIncrement","CXZLXZFPXX"),
    /**
     * 批量出口转内销发票信息查询
     */
    EXPORT_TO_DOMESTIC_SALES_INVOICE("exportToDomesticSalesInvoice","PLCKZNXFPXXCX"),
    /**
     * 批量出口转内销海关缴款书信息查询
     */
    EXPORT_TO_DOMESTIC_SALES_CUSTOMS_PAYMENT("exportToDomesticSalesCustomsPayment","PLCKZNXHGJKSXXCX"),
    /**
     * 批量增值税代扣代缴完税凭证下载申请
     */
    VAT_TAX_PAYMENT_VOUNCHER("vatTaxPaymentVoucher","PLZZSDKDJWSPZXZSQ"),
    /**
     * 批量增值税代扣代缴完税凭证下载申请反馈
     */
    VAT_TAX_PAYMENT_VOUNCHER_RESULT("vatTaxPaymentVoucherResult","PLZZSDKDJWSPZXZSQFK"),
    /**
     * 查询增量下载增值税代扣代缴完税凭证信息
     */
    VAT_TAX_PAYMENT_VOUNCHER_INCREMENT("vatTaxPaymentVoucherIncrement","CXZLXZZZSDKDJWSPZXX"),
    /**
     * 批量消费税代扣代缴完税凭证下载申请
     */
    EXCISE_TAX_PAYMENT_VOUCHER("exciseTaxPaymentVoucher","PLXFSDKDJWSPZXZSQ"),
    /**
     * 批量消费税代扣代缴完税凭证下载申请反馈
     */
    EXCISE_TAX_PAYMENT_VOUCHER_RESULT("exciseTaxPaymentVoucherResult","PLXFSDKDJWSPZXZSQFK"),
    /**
     * 查询增量下载消费税代扣代缴完税凭证信息
     */
    EXCISE_TAX_PAYMENT_VOUCHER_INCREMENT("exciseTaxPaymentVoucherIncrement","CXZLXZXFSDKDJWSPZXX"),
    /**
     * 批量海关缴款书下载申请
     */
    CUSTOMS_PAYMENT("customsPayment","PLHGJKSXZSQ"),
    /**
     * 批量海关缴款书下载申请反馈
     */
    CUSTOMS_PAYMENT_RESULT("customsPaymentResult","PLHGJKSXZSQFK"),
    /**
     * 查询增量下载海关缴款书信息
     */
    CUSTOMS_PAYMENT_INCREMENT("customsPaymentIncrement","CXZLXZHGJKSXX"),
    /**
     * 获取当前税款所属期与当期税款所属期统计状态
     */
    TAX_PERIOD("taxPeriod","HQDQSKSSQYDQSKSSQTJZT"),
    /**
     * 批量发票抵扣勾选
     */
    INVOICE_DEDUCTION_UPLOAD("invoiceDeductionUpload","PLFPDKGX"),
    /**
     * 查询发票抵扣勾选处理结果
     */
    INVOICE_DEDUCTION_UPLOAD_RESULT("invoiceDeductionUploadResult","CXFPDKGXCLJG"),
    /**
     * 批量海关缴款书抵扣勾选
     */
    CUSTOMS_PAYMENT_DEDUCTION_UPLOAD("customsPaymentDeductionUpload","PLHGJKSDKGX"),
    /**
     * 查询海关缴款书抵扣勾选处理结果
     */
    CUSTOMS_PAYMENT_DEDUCTION_UPLOAD_RESULT("customsPaymentDeductionUploadResult","CXHGJKSDKGXCLJG"),
    /**
     * 申请撤销抵扣统计
     */
    DEDUCTION_STATISTICS_APPLY("deductionStatisticsApply","SQCXDKTJ"),
    /**
     * 查询申请撤销统计处理结果
     */
    DEDUCTION_STATISTICS_APPLY_REAULT("deductionStatisticsApplyResult","CXTJCLJG"),
    /**
     * 申请确认抵扣统计
     */
    DEDUCTION_STATISTICS_CONFIRM_APPLY("deductionStatisticsConfirmApply","SQQRDKTJ"),
    /**
     * 查询确认统计处理结果
     */
    DEDUCTION_STATISTICS_CONFIRM_APPLY_RESULT("deductionStatisticsConfirmApplyResult","CXQRTJCLJG"),
    /**
     * 获取当前税款所属期发票抵扣勾选处理结果
     */
    CURRENT_TAX_PERIOD_INVOICE_DEDUCTION("currentTaxPeriodInvoiceDeduction","HQDQSKSSQFPDKGXCLJG"),
    /**
     * 获取当前税款所属期海关缴款书抵扣勾选处理结果
     */
    CURRENT_TAX_PERIOD_CUSTOMS_PAYMENT_DEDUCTION("currentTaxPeriodCustomsPaymentDeduction","HQDQSKSSQHGJKSDKGXCLJG"),
    /**
     * 批量上传增值税代扣代缴完税凭证抵扣勾选
     */
    VAT_TAX_PAYMENT_VOUCHER_DEDUCTION_UPLOAD("vatTaxPaymentVoucherDeductionUpload","PLSCZZSDKDJWSPZDKGX"),
    /**
     * 查询增值税代扣代缴完税凭证抵扣勾选处理结果
     */
    VAT_TAX_PAYMENT_VOUCHER_DEDUCTION_UPLOAD_RESULT("vatTaxPaymentVoucherDeductionUploadResult","CXZZSDKDJWSPZDKGXCLJG"),
    /**
     * 获取当前税款所属期代扣代缴完税凭证抵扣勾选处理结果
     */
    CURRENT_VAT_TAX_PAYMENT_VOUCHER_DEDUCTION("currentVatTaxPaymentVoucherDeduction","HQDQSKSSQDKDJWSPZDKGXCLJG"),
    /**
     * 批量发票退税勾选确认
     */
    INVOICE_TAX_REFUND_UPLOAD("invoiceTaxRefundUpload","PLFPTSGXQR"),
    /**
     * 查询发票退税勾选确认处理结果
     */
    INVOICE_TAX_REFUND_UPLOAD_RESULT("invoiceTaxRefundUploadResult","CXFPTSGXQRCLJG"),
    /**
     * 批量海关缴款书退税勾选确认
     */
    CUSTOMS_PAYMENT_TAX_REFUND_UPLOAD("customsPaymentTaxRefundUpload","PLHGJKSTSGXQR"),
    /**
     * 查询海关缴款书退税勾选确认处理结果
     */
    CUSTOMS_PAYMENT_TAX_REFUND_UPLOAD_RESULT("customsPaymentTaxRefundUploadResult","CXHGJKSTSGXQRCLJG"),
    /**
     * 批量发票代办退税勾选
     */
    INVOICE_DEPUTY_TAX_REFUND_UPLOAD("invoiceDeputyTaxRefundUpload","PLFPDBGX"),
    /**
     * 查询发票代办退税勾选处理结果
     */
    INVOICE_DEPUTY_TAX_REFUND_UPLOAD_RESULT("invoiceDeputyTaxRefundUploadResult","CXDBTSGX"),
    /**
     * 上传发票汇总确认信息
     */
    INVOICE_SUMMARY_UPLOAD("invoiceSummaryUpload","SCFPHZQRXX"),
    /**
     * 查询发票汇总确认信息
     */
    INVOICE_SUMMARY_QUERY("invoiceSummaryQuery","CXFPHZQRXX");


    private String name;
    private String serviceCode;

    NaturalSystemEnums(String name, String serviceCode) {
        this.name = name;
        this.serviceCode = serviceCode;
    }

    public static NaturalSystemEnums fromServiceCode(String serviceCode) {
        final var values = NaturalSystemEnums.values();
        return Arrays.stream(values).filter(naturalSystemEnums -> Objects.equals(serviceCode, naturalSystemEnums.serviceCode)).findFirst().orElse(null);
    }

    public static NaturalSystemEnums fromServiceName(String name) {
        final var values = NaturalSystemEnums.values();
        return Arrays.stream(values).filter(naturalSystemEnums -> Objects.equals(name, naturalSystemEnums.name)).findFirst().orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }
}
