package com.xforceplus.taxware.leqi.kernel.contract.model.base;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 返回体
 *
 * @author Bobo
 * @create 2023/4/10 10:31
 * @since 1.0.0
 */
@Data
public class NaturalSystemBody {

    @JSONField(name = "Response")
    private SubResponse response;

    @Data
    public static class SubResponse {

        @JSONField(name = "RequestId")
        private String requestId;

        @JSONField(name = "Error")
        private ResponseError error;

        @JSONField(name = "Data")
        private String data;
    }

    @Data
    public static class ResponseError {

        @JSONField(name = "Code")
        private String code;

        @JSONField(name = "Message")
        private String message;
    }

    @Data
    public static class BaseResponseData {

        public static final String SUCCESS_CODE = "00";

        /**
         * 返回码
         * 00：成功
         * 其它：失败
         */
        @JSONField(name = "returncode")
        private String returnCode;

        /**
         * 返回信息（非必须）
         * 错误信息说明
         */
        @JSONField(name = "returnmsg")
        private String returnMsg;
    }
}
