package com.xforceplus.taxware.leqi.kernel.contract.model.base.invoice;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Auther lv
 * @Date 2023/7/18
 * @Description: 机动车销售统一发票数据
 *
 *     03：机动车销售统一发票
 */
@Data
public class InvoiceVehicle {
    /**
     * 发票代码
     * 长度：12
     * 非必需
     * 数字化电子发票纸票、税控纸票
     */
    @JSONField(name = "fpdm")
    private String invoiceCode;

    /**
     * 纸质发票号码
     * 长度：8
     * 非必需
     * 税控纸质票号码
     */
    @JSONField(name = "zzfphm")
    private String invoiceNo;

    /**
     * 发票号码
     * 长度：20
     * 非必需
     * 数字化电子发票电票号码
     */
    @JSONField(name = "fphm")
    private String allElectricInvoiceNo;

    /**
     * 报税纳税人识别号
     * 长度：20
     * 必填
     */
    @JSONField(name = "bsNsrsbh")
    private String taxNo;

    /**
     * 开票日期
     * 格式: yyyy-MM-dd HH:mm:ss
     * 长度：19
     * 必需
     */
    @JSONField(name = "kprq")
    private String dateTimeIssued;

    /**
     * 税控码
     * 长度：200
     * 非必需
     */
    @JSONField(name = "skm")
    private String invoiceRiskCode;

    /**
     * 发票状态标识
     * 长度：1
     * 必需
     * 0：正数票
     * 1：负数票
     * 2：空白作废发票
     * 3：正数作废发票
     * 4：负数作废发票
     */
    @JSONField(name = "fpztbz")
    private String status;

    /**
     * 购货单位
     * 长度：370
     * 非必需
     */
    @JSONField(name = "ghdw")
    private String buyerName;

    /**
     * 购买方纳税人
     * 识别号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "gfsbh")
    private String buyerTaxNo;

    /**
     * 身份证号码/组织机构代码
     */
    @JSONField(name = "sfzhm")
    private String buyerId;

    /**
     * 销货单位名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "xhdwmc")
    private String sellerName;

    /**
     * 纳税人识别号
     * 长度：20
     * 必需
     */
    @JSONField(name = "nsrsbh")
    private String sellerTaxNo;

    /**
     * 地址
     * 长度：250
     * 非必需
     */
    @JSONField(name = "dz")
    private String sellerAddress;

    /**
     * 电话
     * 长度：120
     * 非必需
     */
    @JSONField(name = "dh")
    private String sellerTel;

    /**
     * 开户银行
     * 长度：250
     * 非必需
     */
    @JSONField(name = "khyhzh")
    private String sellerBankName;

    /**
     * 账号
     * 长度：300
     * 非必需
     */
    @JSONField(name = "zh")
    private String sellerBankAccount;

    /**
     * 厂牌型号
     * 长度：210
     * 非必需
     */
    @JSONField(name = "cpxh")
    private String vehicleBrand;

    /**
     * 车辆类型
     * 长度：128
     * 非必需
     */
    @JSONField(name = "cllx")
    private String vehicleType;

    /**
     * 合格证书
     * 长度：160
     * 非必需
     */
    @JSONField(name = "hgzs")
    private String certificationNo;

    /**
     * 进口证明书号
     * 长度：128
     * 非必需
     */
    @JSONField(name = "jkzmsh")
    private String importCertificateNo;

    /**
     * 产地
     * 长度：128
     * 非必需
     */
    @JSONField(name = "cd")
    private String productionArea;

    /**
     * 商检单号
     * 长度：128
     * 非必需
     */
    @JSONField(name = "sjdh")
    private String commodityInspectionNo;

    /**
     * 发动机号码
     * 长度：190
     * 非必需
     */
    @JSONField(name = "fdjhm")
    private String engineNo;

    /**
     * 车架号码/车辆识别号
     * 长度：40
     * 非必需
     */
    @JSONField(name = "cjhm")
    private String vehicleNo;

    /**
     * 车价及价外费用(不含增值税)单位：元
     * 非必需
     */
    @JSONField(name = "cjfy")
    private BigDecimal amountWithoutTax;

    /**
     * 增值税税率或征收率如：0.17、0.13、0.00等
     * 非必需
     */
    @JSONField(name = "slv")
    private BigDecimal taxRate;

    /**
     * 增值税税额:单位：元
     * 非必需
     */
    @JSONField(name = "zzsse")
    private BigDecimal taxAmount;

    /**
     * 价税合计:单位：元
     * 非必需
     */
    @JSONField(name = "jshj")
    private BigDecimal amountWithTax;

    /**
     * 代开单位代码
     * 长度：20
     * 非必需
     */
    @JSONField(name = "dkdwdm")
    private String deputyTaxNo;

    /**
     * 代开单位名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "dkdwmc")
    private String deputyName;

    /**
     * 开票人:开票人名称
     * 长度：150
     * 非必需
     */
    @JSONField(name = "kpr")
    private String issuer;

    /**
     * 开票类型
     * 长度：1
     * 必需
     */
    @JSONField(name = "kjlx")
    private String issuedType;

    /**
     * 吨位
     * 长度：64
     * 非必需
     */
    @JSONField(name = "dw")
    private String tonnage;

    /**
     * 限乘人数
     * 长度：40
     * 非必需
     */
    @JSONField(name = "xcrs")
    private String maxCapacity;

    /**
     * 抵扣标志
     * 长度：1
     * 必需
     */
    @JSONField(name = "dkbz")
    private String deductionFlag;

    /**
     * 作废日期
     * 长度：19
     * 非必需
     * YYYY-MM-DD HH:mm:ss
     */
    @JSONField(name = "zfrq")
    private String cancellationTime;

    /**
     * 作废人
     * 长度：150
     * 非必需
     */
    @JSONField(name = "zfr")
    private String cancellationUser;

    /**
     * 接收人代码
     * 长度：16
     * 非必需
     */
    @JSONField(name = "jsrDm")
    private String receiverCode;

    /**
     * 接收人名称
     * 长度：150
     * 非必需
     */
    @JSONField(name = "jsrMc")
    private String receiver;

    /**
     * 接收时间
     * 必需
     */
    @JSONField(name = "jssj")
    private String receiveTime;

    /**
     * 主管税务机关代码:纳税人主管税务机关
     * 长度：11
     * 非必需
     */
    @JSONField(name = "swjgDm")
    private String chargeTaxAuthorityCode;

    /**
     * 接收税务机关代码
     * 长度：11
     * 必需
     */
    @JSONField(name = "jsswjgDm")
    private String receiveTaxAuthorityCode;

    /**
     * 主管税务机关名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "swjgMc")
    private String chargeTaxAuthorityName;

    /**
     * 完税凭证号码
     * 长度：200
     * 非必需
     */
    @JSONField(name = "wspzhm")
    private String taxPaidProof;

    /**
     * 报送方式
     * 长度：1
     * 必需
     */
    @JSONField(name = "bsfs")
    private String submissionMethod;

    /**
     * 编码表版本号
     * 长度：21
     * 非必需
     */
    @JSONField(name = "bmbBbh")
    private String version;

    /**
     * 商品编码
     * 长度：20
     * 非必需
     */
    @JSONField(name = "spbm")
    private String goodsTaxNo;

    /**
     * 自行编码
     * 长度：40
     * 非必需
     */
    @JSONField(name = "zxbm")
    private String itemCode;

    /**
     * 优惠政策标识
     * 长度：1
     * 非必需
     */
    @JSONField(name = "yhzcbs")
    private String taxPreFlag;

    /**
     * 增值税特殊管理
     * 长度：760
     * 非必需
     */
    @JSONField(name = "zzstsgl")
    private String specialManagement;

    /**
     * 零税率标识
     * 长度：10
     * 非必需
     */
    @JSONField(name = "lslbs")
    private String zeroTax;

    /**
     * 适用税率标识
     * 长度：1
     * 非必需
     */
    @JSONField(name = "syslbs")
    private String applyTaxRateFlag;

    /**
     * 3%税率开具理由
     * 长度：2
     * 非必需
     */
    @JSONField(name = "sslkjly")
    private String taxRateReason;
}
