package com.xforceplus.taxware.leqi.kernel.contract.model.buyer;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description: 批量上传退税海关缴款书
 */
public class PostCustomsPaymentTaxRefundUpload {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：20
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        @JSONField(name = "jksmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 填发日期
             * 长度：8
             * 必填
             * YYYYMMDD
             */
            @JSONField(name = "tfrq")
            private String dateIssued;

            /**
             * 缴款书号码
             * 长度：50
             * 非必填
             */
            @JSONField(name = "jkshm")
            private String customsPaymentNo;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 必填
         */
        @JSONField(name = "pclsh")
        private String taskId;

        @JSONField(name = "jksmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 填发日期
             * 长度：8
             * 必填
             * YYYYMMDD
             */
            @JSONField(name = "tfrq")
            private String dateIssued;

            /**
             * 缴款书号码
             * 长度：50
             * 非必填
             */
            @JSONField(name = "jkshm")
            private String customsPaymentNo;

            /**
             * 上传状态
             * 长度：2
             * 必填
             * 00：成功
             * 01：失败
             */
            @JSONField(name = "sczt")
            private String uploadStatus;

            /**
             * 错误信息
             * 长度：2000
             * 非必填
             * 01：失败时记录失败原因
             */
            @JSONField(name = "errormsg")
            private String errorMsg;
        }
    }
}
