package com.xforceplus.taxware.leqi.kernel.contract.model.buyer;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description: 查询发票抵扣勾选处理结果
 */
public class PostInvoiceDeductionUploadResult {
    @Data
    public static class Request {
        /**
         * 批次流水号
         * 长度：32
         * 必填
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 必填
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        @JSONField(name = "fpmx")
        private List<Detail> details;

        @Data
        public static class Detail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 税款所属期
             * 格式YYYYMM，退税成功时该字段不为空
             * 长度：6
             * 非必填
             */
            @JSONField(name = "skssq")
            private String taxPeriod;

            /**
             * 处理结果
             * 长度：2
             * 非必填
             * 01-勾选（撤销）成功
             * 02-查无此票
             * 03-该票异常无法勾选
             * 04-该票已经逾期无法认证
             * 06-已勾选无法重复勾选
             * 07-未到期发票不可勾选（开票月份大于当前属期
             * 11-低版本发票
             * 12-机动车异常发票
             * 13：该票号码重复
             * 99-其它
             */
            @JSONField(name = "cljg")
            private String returnStatus;

            /**
             * 勾选时间
             * 长度：8
             * 非必填
             */
            @JSONField(name = "gxsj")
            private String deductionDate;

            /**
             * 发票状态
             * 长度：1
             * 非必填
             * 处理结果为03-该票异常无法勾选“时，根据实际情况反馈此码值。
             * 0正常
             * 1失控
             * 2作废
             * 3已红冲
             * 7部分红冲
             * 8全额红冲
             */
            @JSONField(name = "fpzt")
            private String status;

            /**
             * 是否异常凭证
             * 长度：2
             * 非必填
             * 处理结果为03-该票异常无法勾选“时，根据实际情况反馈此码值。
             * 01正常
             * 02异常凭证
             * 03疑似异常凭证
             */
            @JSONField(name = "sfycpz")
            private String abnormalStatus;
            /**
             * 锁定状态
             * 长度：2
             * 非必填
             * 处理结果为03-该票异常无法勾选“时，根据实际情况反馈此码值。
             * 01未锁定
             * 02已锁定
             */
            @JSONField(name = "sdzt")
            private String blockStatus;


            /**
             * 当前勾选用途
             * 长度：2
             * 非必填
             * 处理结果为06-已勾选无法重复勾选“时，根据实际情况反馈此码值。
             * 1 已申请抵扣
             * 2 已申请退税
             * 3 已申请代办退税
             * 4 已勾选不抵扣（历史数据）
             * 5 已申请代办退税（历史数据）
             * 6 已申请不抵扣
             * 11 冬奥退税
             */
            @JSONField(name = "hxyt")
            private String deductionPurpose;

            /**
             * 成品油异常标识
             * 长度：1
             * 非必填
             * 处理结果为03-该票异常无法勾选时，根据实际情况反馈此码值
             * 0-正常
             * 1-成品油单价异常
             * 2-成品油超库存异常
             */
            @JSONField(name = "cpyycbs")
            private String oilAbnormalFlag;
        }
    }
}
