package com.xforceplus.taxware.leqi.kernel.contract.model.buyer;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description: 批量上传退税发票
 */
public class PostInvoiceTaxRefundUpload {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：20
         * 非必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        @JSONField(name = "fpmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 发票类型
             * 长度：2
             * 必填
             * 01:增值税专用发票
             * 08:增值税电子专用发票
             * 81:电子发票(增值税专用发票)
             * 85:纸质发票(增值税专用发票)
             * */
            @JSONField(name = "fplx")
            private String invoiceType;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 必填
         */
        @JSONField(name = "pclsh")
        private String taskId;

        @JSONField(name = "fpmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 上传状态
             * 长度：2
             * 必填
             * 00：成功
             * 01：失败
             */
            @JSONField(name = "sczt")
            private String uploadStatus;

            /**
             * 错误信息
             * 长度：2000
             * 非必填
             * 01：失败时记录失败原因
             */
            @JSONField(name = "errormsg")
            private String errorMsg;
        }
    }

}
