package com.xforceplus.taxware.leqi.kernel.contract.model.buyer;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description: 获取当前税款所属期与当期税款所属期统计状态
 */
public class PostTaxPeriod {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：20
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 税款所属期
         * 格式YYYYMM，抵扣成功时该字段不为空
         * 长度：6
         * 非必填
         */
        @JSONField(name = "skssq")
        private String taxPeriod;

        /**
         * 统计状态
         * 长度：2
         * 必需
         * 0：未统计
         * 1：已统计
         * 2：已确认
         */
        @JSONField(name = "zt")
        private String status;
    }
}
