package com.xforceplus.taxware.leqi.kernel.contract.model.collection;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lvwenjing
 * @date 2023/4/21
 * @describe: 批量海关缴款书下载申请反馈
 */
public class PostCustomsPaymentResultMessage {

    @Data
    public static class Request {

        /**
         * 批次流水号
         * 长度：30
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 数据包号，当数据量过大时会进行分包处理;新的流水号初次调用接口时包号为1，后续请求包号在返回参数总包数范围内顺序增加;
         * 长度：5
         */
        @JSONField(name = "packageno")
        private String packageNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 当前流水号下 的总包数
         * 长度：5
         */
        @JSONField(name = "packagecount")
        private String packageCount;

        /**
         * 纳税人识别号/统一社会信用代码
         * 长度：30
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 处理结果
         * 长度：1
         * 1:成功
         * 2:不存在符合条件的发票
         * 3:失败
         */
        @JSONField(name = "cljg")
        private String returnStatus;

        /**
         * 数据类型
         * 压缩包文件流 (gzip+base64)，
         * 原始数据为json报文Json
         */
        @JSONField(name = "sjl")
        private String returnData;
    }
}
